/*
 * Decompiled with CFR 0.152.
 */
package pixela.client.impl;

import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import pixela.client.PixelaClientConfig;
import pixela.client.http.json.JsonDecoder;
import pixela.client.impl.JdkHttpResponse;
import reactor.core.publisher.Mono;

class JdkHttpClient {
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final JsonDecoder decoder;

    private JdkHttpClient(@NotNull HttpClient httpClient, @NotNull JsonDecoder decoder) {
        this.httpClient = httpClient;
        this.decoder = decoder;
    }

    @NotNull
    static JdkHttpClient create(@NotNull ExecutorService executorService, @NotNull JsonDecoder decoder, @NotNull PixelaClientConfig config) {
        HttpClient httpClient = HttpClient.newBuilder().executor(executorService).connectTimeout(Duration.ofMillis(config.getTimeout())).followRedirects(HttpClient.Redirect.ALWAYS).version(HttpClient.Version.HTTP_2).build();
        return JdkHttpClient.create(httpClient, decoder);
    }

    @NotNull
    <T> Mono<T> decodeJson(@NotNull String json, @NotNull Class<T> type) {
        return this.decoder.decode(json, type);
    }

    @NotNull
    static JdkHttpClient create(@NotNull HttpClient httpClient, @NotNull JsonDecoder decoder) {
        return new JdkHttpClient(httpClient, decoder);
    }

    @NotNull
    Mono<JdkHttpResponse> sendRequest(@NotNull HttpRequest request) {
        Mono response = Mono.fromFuture(this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8)));
        return response.map(res -> JdkHttpResponse.create(res, this.decoder));
    }
}

