/*
 * Decompiled with CFR 0.152.
 */
package pixela.client.impl;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pixela.client.ApiException;
import pixela.client.BasicResponse;
import pixela.client.http.HttpResponse;
import pixela.client.http.Request;
import pixela.client.http.json.JsonDecoder;
import reactor.core.publisher.Mono;

class JdkHttpResponse
implements HttpResponse {
    @NotNull
    private final java.net.http.HttpResponse<String> response;
    @NotNull
    private final JsonDecoder decoder;

    private JdkHttpResponse(@NotNull java.net.http.HttpResponse<String> response, @NotNull JsonDecoder decoder) {
        this.response = response;
        this.decoder = decoder;
    }

    @NotNull
    @Contract(value="_, _ -> new")
    static JdkHttpResponse create(@NotNull java.net.http.HttpResponse<String> response, @NotNull JsonDecoder decoder) {
        return new JdkHttpResponse(response, decoder);
    }

    @NotNull
    public String body() {
        return this.response.body();
    }

    public boolean isErrorResponse() {
        return this.statusCode() / 100 != 2;
    }

    <T> Mono<T> readObject(Request<T> request) {
        String json = this.body();
        Class responseType = request.responseType();
        if (this.isErrorResponse()) {
            Mono response = this.decoder.decode(json, BasicResponse.class);
            return response.map(BasicResponse::getMessage).flatMap(message -> Mono.error((Throwable)ApiException.of((String)message)));
        }
        if (responseType.equals(Void.class)) {
            Mono response = this.decoder.decode(json, BasicResponse.class);
            return response.flatMap(res -> res.emptyOrError());
        }
        if (responseType.equals(String.class)) {
            return Mono.just((Object)json);
        }
        return this.decoder.decode(json, responseType);
    }

    int statusCode() {
        return this.response.statusCode();
    }
}

