/*
 * Decompiled with CFR 0.152.
 */
package pixela.client.impl;

import java.net.URI;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pixela.client.http.Post;
import pixela.client.http.Request;
import pixela.client.http.json.JsonEncoder;
import pixela.client.impl.ContentTypeHeader;
import pixela.client.impl.RequestBuilder;
import pixela.client.impl.RequestConfigurer;
import pixela.client.impl.UserTokenHeader;
import reactor.core.publisher.Mono;

class JdkPostRequestBuilder
implements RequestBuilder<Post<?>> {
    @NotNull
    private final JsonEncoder encoder;
    @NotNull
    private final RequestConfigurer configurer;

    private JdkPostRequestBuilder(@NotNull URI baseUri, @NotNull JsonEncoder encoder) {
        this(encoder, new ReqConfigurer(baseUri));
    }

    JdkPostRequestBuilder(@NotNull JsonEncoder encoder, @NotNull RequestConfigurer configurer) {
        this.configurer = configurer;
        this.encoder = encoder;
    }

    @Contract(value="_, _ -> new")
    @NotNull
    static JdkPostRequestBuilder of(@NotNull URI baseUri, @NotNull JsonEncoder encoder) {
        return new JdkPostRequestBuilder(baseUri, encoder);
    }

    @Override
    @NotNull
    public Mono<HttpRequest> apply(@NotNull Post<?> post) {
        return this.encoder.encode(post).map(payload -> HttpRequest.BodyPublishers.ofString(payload, StandardCharsets.UTF_8)).switchIfEmpty(Mono.just((Object)HttpRequest.BodyPublishers.noBody())).map(pub -> this.configurer.configureRequest((Request<?>)post, (HttpRequest.BodyPublisher)pub));
    }

    static class ReqConfigurer
    implements RequestConfigurer {
        @NotNull
        final URI baseUri;

        ReqConfigurer(@NotNull URI baseUri) {
            this.baseUri = baseUri;
        }

        @Override
        @NotNull
        public HttpRequest configureRequest(@NotNull Request<?> request, @NotNull HttpRequest.BodyPublisher bodyPublisher) {
            URI endpoint = request.apiEndpoint(this.baseUri);
            HttpRequest.Builder builder = HttpRequest.newBuilder(endpoint).POST(bodyPublisher);
            return Stream.of(UserTokenHeader.of(request), ContentTypeHeader.of(request)).reduce(builder, (b, h) -> h.configure(b), (l, r) -> l).build();
        }
    }
}

