/*
 * Decompiled with CFR 0.152.
 */
package pixela.client.impl;

import java.net.URI;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import pixela.client.http.Put;
import pixela.client.http.Request;
import pixela.client.http.json.JsonEncoder;
import pixela.client.impl.ContentTypeHeader;
import pixela.client.impl.RequestBuilder;
import pixela.client.impl.RequestConfigurer;
import pixela.client.impl.UserTokenHeader;
import reactor.core.publisher.Mono;

class JdkPutRequestBuilder
implements RequestBuilder<Put<?>> {
    @NotNull
    private final JsonEncoder encoder;
    @NotNull
    private final RequestConfigurer configurer;

    JdkPutRequestBuilder(@NotNull JsonEncoder encoder, @NotNull RequestConfigurer configurer) {
        this.encoder = encoder;
        this.configurer = configurer;
    }

    @NotNull
    static JdkPutRequestBuilder of(@NotNull URI uri, @NotNull JsonEncoder encoder) {
        PutRequestConfigurer configurer = new PutRequestConfigurer(uri);
        return new JdkPutRequestBuilder(encoder, configurer);
    }

    @Override
    @NotNull
    public Mono<HttpRequest> apply(@NotNull Put<?> request) {
        return this.encoder.encode(request).map(payload -> HttpRequest.BodyPublishers.ofString(payload, StandardCharsets.UTF_8)).switchIfEmpty(Mono.just((Object)HttpRequest.BodyPublishers.noBody())).map(pub -> this.configurer.configureRequest((Request<?>)request, (HttpRequest.BodyPublisher)pub));
    }

    static class PutRequestConfigurer
    implements RequestConfigurer {
        private final URI baseUri;

        PutRequestConfigurer(URI baseUri) {
            this.baseUri = baseUri;
        }

        @Override
        @NotNull
        public HttpRequest configureRequest(@NotNull Request<?> request, @NotNull HttpRequest.BodyPublisher bodyPublisher) {
            URI endpoint = request.apiEndpoint(this.baseUri);
            HttpRequest.Builder builder = HttpRequest.newBuilder(endpoint).PUT(bodyPublisher);
            return Stream.of(UserTokenHeader.of(request), ContentTypeHeader.of(request)).reduce(builder, (b, h) -> h.configure(b), (l, r) -> l).build();
        }
    }
}

