/*
 * Decompiled with CFR 0.152.
 */
package pixela.client.impl;

import java.net.URI;
import java.net.http.HttpRequest;
import org.jetbrains.annotations.NotNull;
import pixela.client.http.Delete;
import pixela.client.http.Get;
import pixela.client.http.Post;
import pixela.client.http.Put;
import pixela.client.http.json.JsonEncoder;
import pixela.client.impl.JdkDeleteRequestBuilder;
import pixela.client.impl.JdkGetRequestBuilder;
import pixela.client.impl.JdkPostRequestBuilder;
import pixela.client.impl.JdkPutRequestBuilder;
import reactor.core.publisher.Mono;

class JdkRequestBuilder {
    @NotNull
    private final URI baseUri;
    @NotNull
    private final JsonEncoder encoder;
    @NotNull
    private final JdkGetRequestBuilder getBuilder;
    @NotNull
    private final JdkPostRequestBuilder postBuilder;
    @NotNull
    private final JdkPutRequestBuilder putBuilder;
    @NotNull
    private final JdkDeleteRequestBuilder deleteBuilder;

    private JdkRequestBuilder(@NotNull URI baseUri, @NotNull JsonEncoder encoder, @NotNull JdkGetRequestBuilder getBuilder, @NotNull JdkPostRequestBuilder postBuilder, @NotNull JdkPutRequestBuilder putBuilder, @NotNull JdkDeleteRequestBuilder deleteBuilder) {
        this.baseUri = baseUri;
        this.encoder = encoder;
        this.getBuilder = getBuilder;
        this.postBuilder = postBuilder;
        this.putBuilder = putBuilder;
        this.deleteBuilder = deleteBuilder;
    }

    static JdkRequestBuilder create(@NotNull URI baseUri, @NotNull JsonEncoder encoder) {
        return new JdkRequestBuilder(baseUri, encoder, JdkGetRequestBuilder.of(baseUri), JdkPostRequestBuilder.of(baseUri, encoder), JdkPutRequestBuilder.of(baseUri, encoder), JdkDeleteRequestBuilder.of(baseUri));
    }

    URI baseUri() {
        return this.baseUri;
    }

    @NotNull
    Mono<String> encodeJson(@NotNull Object object) {
        return this.encoder.encodeObject(object);
    }

    @NotNull
    Mono<HttpRequest> get(@NotNull Get<?> get) {
        return this.getBuilder.apply(get);
    }

    @NotNull
    Mono<HttpRequest> post(@NotNull Post<?> post) {
        return this.postBuilder.apply(post);
    }

    @NotNull
    <T> Mono<HttpRequest> put(@NotNull Put<T> put) {
        return this.putBuilder.apply(put);
    }

    @NotNull
    Mono<HttpRequest> delete(@NotNull Delete<?> delete) {
        return this.deleteBuilder.apply(delete);
    }
}

