/*
 * Decompiled with CFR 0.152.
 */
package pixela.client.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import pixela.client.http.json.JsonCodec;
import pixela.client.impl.Exceptions;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class JsonCodecImpl
implements JsonCodec {
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final ObjectMapper objectMapper;

    JsonCodecImpl(@NotNull ExecutorService executorService, @NotNull ObjectMapper objectMapper) {
        this.executorService = executorService;
        this.objectMapper = objectMapper;
    }

    @NotNull
    public <T> Mono<T> decode(@NotNull String json, @NotNull Class<T> type) {
        CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> this.decodeSync(json, type), this.executorService);
        return Mono.create(sink -> ((CompletableFuture)future.thenAccept(arg_0 -> ((MonoSink)sink).success(arg_0))).exceptionally(Exceptions.asFunction(arg_0 -> ((MonoSink)sink).error(arg_0))));
    }

    <T> T decodeSync(@NotNull String json, @NotNull Class<T> type) {
        try {
            return (T)this.objectMapper.readValue(json, type);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NotNull
    public Mono<String> encodeObject(@NotNull Object object) {
        CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> this.encodeSync(object), this.executorService);
        return Mono.create(sink -> ((CompletableFuture)future.thenAccept(arg_0 -> ((MonoSink)sink).success(arg_0))).exceptionally(Exceptions.asFunction(arg_0 -> ((MonoSink)sink).error(arg_0))));
    }

    String encodeSync(@NotNull Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

