/*
 * Decompiled with CFR 0.152.
 */
package pixela.client.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Mono;

interface SupplierExecutor {
    @NotNull
    public <T> Mono<T> runSupplier(@NotNull Supplier<? extends T> var1);

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static SupplierExecutor fromExecutorService(final @NotNull ExecutorService executorService) {
        return new SupplierExecutor(){

            @Override
            @NotNull
            public <T> Mono<T> runSupplier(@NotNull Supplier<? extends T> supplier) {
                return Mono.defer(() -> Mono.fromFuture(CompletableFuture.supplyAsync(supplier, executorService)));
            }
        };
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static SupplierExecutor noExecutor() {
        return new SupplierExecutor(){

            @Override
            @NotNull
            public <T> Mono<T> runSupplier(@NotNull Supplier<? extends T> supplier) {
                return Mono.fromSupplier(supplier);
            }
        };
    }
}

