/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.miniscript.python;

import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.mini2Dx.miniscript.core.GameScript;
import org.mini2Dx.miniscript.core.GameScriptingEngine;
import org.mini2Dx.miniscript.core.ScriptBindings;
import org.mini2Dx.miniscript.core.ScriptExecutionTask;
import org.mini2Dx.miniscript.core.ScriptExecutor;
import org.mini2Dx.miniscript.core.ScriptExecutorPool;
import org.mini2Dx.miniscript.core.ScriptInvocationListener;
import org.mini2Dx.miniscript.core.exception.InsufficientCompilersException;
import org.mini2Dx.miniscript.core.exception.NoSuchScriptException;
import org.mini2Dx.miniscript.core.exception.ScriptExecutorUnavailableException;
import org.mini2Dx.miniscript.python.PythonScriptExecutor;
import org.python.core.PyCode;

public class PythonScriptExecutorPool
implements ScriptExecutorPool<PyCode> {
    private final Map<Integer, GameScript<PyCode>> scripts = new ConcurrentHashMap<Integer, GameScript<PyCode>>();
    private final BlockingQueue<ScriptExecutor<PyCode>> executors;
    private final GameScriptingEngine gameScriptingEngine;

    public PythonScriptExecutorPool(GameScriptingEngine gameScriptingEngine, int poolSize) {
        this.gameScriptingEngine = gameScriptingEngine;
        this.executors = new ArrayBlockingQueue<ScriptExecutor<PyCode>>(poolSize);
        for (int i = 0; i < poolSize; ++i) {
            this.executors.offer(new PythonScriptExecutor(this));
        }
    }

    public int preCompileScript(String scriptContent) throws InsufficientCompilersException {
        ScriptExecutor executor = (ScriptExecutor)this.executors.poll();
        if (executor == null) {
            throw new InsufficientCompilersException();
        }
        GameScript script = executor.compile(scriptContent);
        executor.release();
        this.scripts.put(script.getId(), (GameScript<PyCode>)script);
        return script.getId();
    }

    public ScriptExecutionTask<?> execute(int scriptId, ScriptBindings scriptBindings, ScriptInvocationListener invocationListener) {
        ScriptExecutor<PyCode> executor = this.allocateExecutor();
        if (executor == null) {
            throw new ScriptExecutorUnavailableException(scriptId);
        }
        if (!this.scripts.containsKey(scriptId)) {
            throw new NoSuchScriptException(scriptId);
        }
        return new ScriptExecutionTask(this.gameScriptingEngine, executor, scriptId, this.scripts.get(scriptId), scriptBindings, invocationListener);
    }

    public void release(ScriptExecutor<PyCode> executor) {
        try {
            this.executors.put(executor);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private ScriptExecutor<PyCode> allocateExecutor() {
        try {
            return this.executors.take();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public GameScriptingEngine getGameScriptingEngine() {
        return this.gameScriptingEngine;
    }
}

