/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.miniscript.python;

import java.io.OutputStream;
import org.mini2Dx.miniscript.core.EmbeddedScriptInvoker;
import org.mini2Dx.miniscript.core.GameScript;
import org.mini2Dx.miniscript.core.GlobalGameScript;
import org.mini2Dx.miniscript.core.ScriptBindings;
import org.mini2Dx.miniscript.core.ScriptExecutionResult;
import org.mini2Dx.miniscript.core.ScriptExecutor;
import org.mini2Dx.miniscript.core.exception.ScriptSkippedException;
import org.mini2Dx.miniscript.python.PythonEmbeddedScriptInvoker;
import org.mini2Dx.miniscript.python.PythonScriptExecutorPool;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyStringMap;
import org.python.util.InteractiveInterpreter;

public class PythonScriptExecutor
implements ScriptExecutor<PyCode> {
    private final PythonScriptExecutorPool executorPool;
    private final InteractiveInterpreter pythonInterpreter;

    public PythonScriptExecutor(PythonScriptExecutorPool executorPool) {
        this.executorPool = executorPool;
        this.pythonInterpreter = new InteractiveInterpreter();
        this.pythonInterpreter.setErr((OutputStream)System.err);
        this.pythonInterpreter.setOut((OutputStream)System.out);
    }

    public GameScript<PyCode> compile(String script) {
        return new GlobalGameScript((Object)this.pythonInterpreter.compile(script));
    }

    public ScriptExecutionResult execute(int scriptId, GameScript<PyCode> script, ScriptBindings bindings, boolean returnResult) throws Exception {
        PyCode pythonScript = (PyCode)script.getScript();
        PythonEmbeddedScriptInvoker embeddedScriptInvoker = (PythonEmbeddedScriptInvoker)((Object)this.executorPool.getEmbeddedScriptInvokerPool().allocate());
        embeddedScriptInvoker.setScriptBindings(bindings);
        embeddedScriptInvoker.setScriptExecutor(this);
        embeddedScriptInvoker.setParentScriptId(scriptId);
        for (String variableName : bindings.keySet()) {
            this.pythonInterpreter.set(variableName, bindings.get((Object)variableName));
        }
        this.pythonInterpreter.set("scriptParentId", (Object)-1);
        this.pythonInterpreter.set("scriptId", (Object)scriptId);
        this.pythonInterpreter.set("scripts", (Object)embeddedScriptInvoker);
        try {
            this.pythonInterpreter.exec((PyObject)pythonScript);
        }
        catch (PyException e) {
            if (e.getCause() instanceof ScriptSkippedException) {
                throw new ScriptSkippedException();
            }
            throw e;
        }
        this.executorPool.getEmbeddedScriptInvokerPool().release((Object)embeddedScriptInvoker);
        if (!returnResult) {
            return null;
        }
        ScriptExecutionResult executionResult = new ScriptExecutionResult(null);
        PyStringMap locals = (PyStringMap)this.pythonInterpreter.getLocals();
        for (Object key : locals.keys()) {
            executionResult.put(key.toString(), this.pythonInterpreter.get(key.toString(), Object.class));
        }
        return executionResult;
    }

    public void executeEmbedded(int parentScriptId, int scriptId, GameScript<PyCode> script, EmbeddedScriptInvoker embeddedScriptInvoker, ScriptBindings bindings) throws Exception {
        PyCode pythonScript = (PyCode)script.getScript();
        this.pythonInterpreter.set("scriptParentId", (Object)parentScriptId);
        this.pythonInterpreter.set("scriptId", (Object)scriptId);
        embeddedScriptInvoker.setParentScriptId(scriptId);
        try {
            this.pythonInterpreter.exec((PyObject)pythonScript);
        }
        catch (PyException e) {
            if (e.getCause() instanceof ScriptSkippedException) {
                throw new ScriptSkippedException();
            }
            throw e;
        }
        this.pythonInterpreter.set("scriptId", (Object)parentScriptId);
        embeddedScriptInvoker.setParentScriptId(parentScriptId);
        PyStringMap locals = (PyStringMap)this.pythonInterpreter.getLocals();
        for (Object key : locals.keys()) {
            bindings.put(key.toString(), this.pythonInterpreter.get(key.toString(), Object.class));
        }
    }

    public void release() {
        try {
            this.pythonInterpreter.cleanup();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.executorPool.release(this);
    }
}

