/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.miniscript.python;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import org.mini2Dx.miniscript.core.GameScript;
import org.mini2Dx.miniscript.core.GameScriptingEngine;
import org.mini2Dx.miniscript.core.ScriptBindings;
import org.mini2Dx.miniscript.core.ScriptExecutionTask;
import org.mini2Dx.miniscript.core.ScriptExecutor;
import org.mini2Dx.miniscript.core.ScriptExecutorPool;
import org.mini2Dx.miniscript.core.ScriptInvocationListener;
import org.mini2Dx.miniscript.core.SynchronizedObjectPool;
import org.mini2Dx.miniscript.core.exception.InsufficientCompilersException;
import org.mini2Dx.miniscript.core.exception.NoSuchScriptException;
import org.mini2Dx.miniscript.core.exception.ScriptExecutorUnavailableException;
import org.mini2Dx.miniscript.core.util.ReadWriteBlockingQueue;
import org.mini2Dx.miniscript.core.util.ReadWriteMap;
import org.mini2Dx.miniscript.python.PythonEmbeddedScriptInvoker;
import org.mini2Dx.miniscript.python.PythonScriptExecutor;
import org.python.core.PyCode;

public class PythonScriptExecutorPool
implements ScriptExecutorPool<PyCode> {
    private final Map<Integer, GameScript<PyCode>> scripts = new ReadWriteMap();
    private final Map<String, Integer> filepathToScriptId = new ReadWriteMap();
    private final Map<Integer, String> scriptIdToFilepath = new ReadWriteMap();
    private final BlockingQueue<ScriptExecutor<PyCode>> executors;
    private final GameScriptingEngine gameScriptingEngine;
    private final SynchronizedObjectPool<PythonEmbeddedScriptInvoker> embeddedScriptInvokerPool = new SynchronizedObjectPool<PythonEmbeddedScriptInvoker>(){

        protected PythonEmbeddedScriptInvoker construct() {
            return new PythonEmbeddedScriptInvoker(PythonScriptExecutorPool.this.gameScriptingEngine, PythonScriptExecutorPool.this);
        }
    };

    public PythonScriptExecutorPool(GameScriptingEngine gameScriptingEngine, int poolSize) {
        this.gameScriptingEngine = gameScriptingEngine;
        this.executors = new ReadWriteBlockingQueue(poolSize);
        for (int i = 0; i < poolSize; ++i) {
            this.executors.offer(new PythonScriptExecutor(this));
        }
    }

    public int getCompiledScriptId(String filepath) {
        return this.filepathToScriptId.getOrDefault(filepath, -1);
    }

    public String getCompiledScriptPath(int scriptId) {
        return this.scriptIdToFilepath.get(scriptId);
    }

    public int preCompileScript(String filepath, String scriptContent) throws InsufficientCompilersException {
        ScriptExecutor executor = (ScriptExecutor)this.executors.poll();
        if (executor == null) {
            throw new InsufficientCompilersException();
        }
        GameScript script = executor.compile(scriptContent);
        executor.release();
        this.scripts.put(script.getId(), (GameScript<PyCode>)script);
        this.filepathToScriptId.put(filepath, script.getId());
        this.scriptIdToFilepath.put(script.getId(), filepath);
        return script.getId();
    }

    public ScriptExecutionTask<?> execute(int taskId, int scriptId, ScriptBindings scriptBindings, ScriptInvocationListener invocationListener, boolean syncCall) {
        ScriptExecutor<PyCode> executor = this.allocateExecutor();
        if (executor == null) {
            throw new ScriptExecutorUnavailableException(scriptId);
        }
        if (!this.scripts.containsKey(scriptId)) {
            executor.release();
            throw new NoSuchScriptException(scriptId);
        }
        return new ScriptExecutionTask(taskId, this.gameScriptingEngine, executor, scriptId, this.scripts.get(scriptId), scriptBindings, invocationListener, syncCall);
    }

    public void release(ScriptExecutor<PyCode> executor) {
        try {
            this.executors.put(executor);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private ScriptExecutor<PyCode> allocateExecutor() {
        try {
            return this.executors.take();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public GameScriptingEngine getGameScriptingEngine() {
        return this.gameScriptingEngine;
    }

    GameScript<PyCode> getScript(int scriptId) {
        return this.scripts.get(scriptId);
    }

    public SynchronizedObjectPool<PythonEmbeddedScriptInvoker> getEmbeddedScriptInvokerPool() {
        return this.embeddedScriptInvokerPool;
    }
}

