/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.server;

import com.google.common.annotations.VisibleForTesting;
import org.mockserver.client.server.MockServerClient;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpCallback;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpResponse;

public class ForwardChainExpectation {
    private final MockServerClient mockServerClient;
    private final Expectation expectation;

    public ForwardChainExpectation(MockServerClient mockServerClient, Expectation expectation) {
        this.mockServerClient = mockServerClient;
        this.expectation = expectation;
    }

    public void respond(HttpResponse httpResponse) {
        this.expectation.thenRespond(httpResponse);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void forward(HttpForward httpForward) {
        this.expectation.thenForward(httpForward);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void error(HttpError httpError) {
        this.expectation.thenError(httpError);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void callback(HttpCallback httpCallback) {
        this.expectation.thenCallback(httpCallback);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    @VisibleForTesting
    Expectation getExpectation() {
        return this.expectation;
    }
}

