/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.server;

import com.google.common.annotations.VisibleForTesting;
import org.mockserver.client.netty.websocket.WebSocketClient;
import org.mockserver.client.server.MockServerClient;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.action.ExpectationCallback;
import org.mockserver.model.HttpClassCallback;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpResponse;

public class ForwardChainExpectation {
    private final MockServerClient mockServerClient;
    private final Expectation expectation;
    private WebSocketClient webSocketClient;

    public ForwardChainExpectation(MockServerClient mockServerClient, Expectation expectation) {
        this.mockServerClient = mockServerClient;
        this.expectation = expectation;
    }

    public void respond(HttpResponse httpResponse) {
        this.expectation.thenRespond(httpResponse);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void forward(HttpForward httpForward) {
        this.expectation.thenForward(httpForward);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void error(HttpError httpError) {
        this.expectation.thenError(httpError);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void callback(HttpClassCallback httpClassCallback) {
        this.expectation.thenCallback(httpClassCallback);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void callback(ExpectationCallback httpObjectCallback) {
        if (this.webSocketClient == null) {
            this.webSocketClient = new WebSocketClient(this.mockServerClient.remoteAddress(), this.mockServerClient.contextPath());
        }
        this.expectation.thenCallback(new HttpObjectCallback().withClientId(this.webSocketClient.registerExpectationCallback(httpObjectCallback).clientId()));
        this.mockServerClient.sendExpectation(this.expectation);
    }

    @VisibleForTesting
    Expectation getExpectation() {
        return this.expectation;
    }

    @VisibleForTesting
    void setWebSocketClient(WebSocketClient webSocketClient) {
        this.webSocketClient = webSocketClient;
    }
}

