/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mappers;

import java.io.IOException;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.mockserver.model.Cookie;
import org.mockserver.model.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheHttpClientToMockServerResponseMapper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public HttpResponse mapApacheHttpClientResponseToMockServerResponse(CloseableHttpResponse clientResponse) throws IOException {
        HttpResponse httpResponse = new HttpResponse();
        this.setStatusCode(httpResponse, clientResponse);
        this.setHeaders(httpResponse, clientResponse);
        this.setCookies(httpResponse);
        if (clientResponse.getEntity() != null) {
            this.setBody(httpResponse, EntityUtils.toByteArray((HttpEntity)clientResponse.getEntity()));
        }
        return httpResponse;
    }

    private void setStatusCode(HttpResponse httpResponse, CloseableHttpResponse clientResponse) {
        if (clientResponse.getStatusLine() != null) {
            httpResponse.withStatusCode(Integer.valueOf(clientResponse.getStatusLine().getStatusCode()));
        }
    }

    private void setHeaders(HttpResponse httpResponse, CloseableHttpResponse clientResponse) {
        HashMap<String, org.mockserver.model.Header> mappedHeaders = new HashMap<String, org.mockserver.model.Header>();
        for (Header header : clientResponse.getAllHeaders()) {
            if (mappedHeaders.containsKey(header.getName())) {
                ((org.mockserver.model.Header)mappedHeaders.get(header.getName())).addValue(header.getValue());
                continue;
            }
            mappedHeaders.put(header.getName(), new org.mockserver.model.Header(header.getName(), new String[]{header.getValue()}));
        }
        ArrayList headers = new ArrayList(mappedHeaders.values());
        List<String> headersToRemove = Arrays.asList("Content-Encoding", "Content-Length", "Transfer-Encoding");
        for (Header header : new ArrayList(headers)) {
            if (!headersToRemove.contains(header.getName())) continue;
            headers.remove(header);
        }
        httpResponse.withHeaders(headers);
    }

    private void setCookies(HttpResponse httpResponse) {
        HashMap<String, Cookie> mappedCookies = new HashMap<String, Cookie>();
        for (org.mockserver.model.Header header : httpResponse.getHeaders()) {
            if (!header.getName().equals("Cookie") && !header.getName().equals("Set-Cookie")) continue;
            for (String cookieHeader : header.getValues()) {
                try {
                    for (HttpCookie httpCookie : HttpCookie.parse(cookieHeader)) {
                        if (mappedCookies.containsKey(httpCookie.getName())) {
                            ((Cookie)mappedCookies.get(httpCookie.getName())).addValue(httpCookie.getValue());
                            continue;
                        }
                        mappedCookies.put(httpCookie.getName(), new Cookie(httpCookie.getName(), new String[]{httpCookie.getValue()}));
                    }
                }
                catch (IllegalArgumentException iae) {
                    this.logger.warn("Exception while parsing cookie header [" + cookieHeader + "]", (Throwable)iae);
                }
            }
        }
        httpResponse.withCookies(new ArrayList(mappedCookies.values()));
    }

    private void setBody(HttpResponse httpResponse, byte[] content) {
        httpResponse.withBody(content);
    }
}

