/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.Bytes;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBConnector;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.OutMessage;
import com.mongodb.Response;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.types.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBApiLayer
extends DB {
    static final boolean D = Boolean.getBoolean("DEBUG.DB");
    static final int NUM_CURSORS_BEFORE_KILL = 100;
    static final int NUM_CURSORS_PER_BATCH = 20000;
    static final Logger TRACE_LOGGER = Logger.getLogger("com.mongodb.TRACE");
    static final Level TRACE_LEVEL = Boolean.getBoolean("DB.TRACE") ? Level.INFO : Level.FINEST;
    final String _root;
    final String _rootPlusDot;
    final DBConnector _connector;
    final Map<String, MyCollection> _collections = Collections.synchronizedMap(new HashMap());
    ConcurrentLinkedQueue<DeadCursor> _deadCursorIds = new ConcurrentLinkedQueue();
    static final List<DBObject> EMPTY = Collections.unmodifiableList(new LinkedList());

    static final boolean willTrace() {
        return TRACE_LOGGER.isLoggable(TRACE_LEVEL);
    }

    static final void trace(String s) {
        TRACE_LOGGER.log(TRACE_LEVEL, s);
    }

    static int chooseBatchSize(int batchSize, int limit, int fetched) {
        int bs = Math.abs(batchSize);
        int remaining = limit > 0 ? limit - fetched : 0;
        int res = 0;
        res = bs == 0 && remaining > 0 ? remaining : (bs > 0 && remaining == 0 ? bs : Math.min(bs, remaining));
        if (batchSize < 0) {
            res = -res;
        }
        if (res == 1) {
            res = -1;
        }
        return res;
    }

    protected DBApiLayer(Mongo mongo, String name, DBConnector connector) {
        super(mongo, name);
        if (connector == null) {
            throw new IllegalArgumentException("need a connector: " + name);
        }
        this._root = name;
        this._rootPlusDot = this._root + ".";
        this._connector = connector;
    }

    @Override
    public void requestStart() {
        this._connector.requestStart();
    }

    @Override
    public void requestDone() {
        this._connector.requestDone();
    }

    @Override
    public void requestEnsureConnection() {
        this._connector.requestEnsureConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MyCollection doGetCollection(String name) {
        MyCollection c = this._collections.get(name);
        if (c != null) {
            return c;
        }
        Map<String, MyCollection> map = this._collections;
        synchronized (map) {
            c = this._collections.get(name);
            if (c != null) {
                return c;
            }
            c = new MyCollection(name);
            this._collections.put(name, c);
        }
        return c;
    }

    String _removeRoot(String ns) {
        if (!ns.startsWith(this._rootPlusDot)) {
            return ns;
        }
        return ns.substring(this._root.length() + 1);
    }

    @Override
    public void cleanCursors(boolean force) throws MongoException {
        DeadCursor c;
        int sz = this._deadCursorIds.size();
        if (sz == 0 || !force && sz < 100) {
            return;
        }
        Bytes.LOGGER.info("going to kill cursors : " + sz);
        HashMap<ServerAddress, LinkedList<Long>> m = new HashMap<ServerAddress, LinkedList<Long>>();
        while ((c = this._deadCursorIds.poll()) != null) {
            LinkedList<Long> x = (LinkedList<Long>)m.get(c.host);
            if (x == null) {
                x = new LinkedList<Long>();
                m.put(c.host, x);
            }
            x.add(c.id);
        }
        for (Map.Entry e : m.entrySet()) {
            try {
                this.killCursors((ServerAddress)e.getKey(), (List)e.getValue());
            }
            catch (Throwable t) {
                Bytes.LOGGER.log(Level.WARNING, "can't clean cursors", t);
                for (Long x : (List)e.getValue()) {
                    this._deadCursorIds.add(new DeadCursor(x, (ServerAddress)e.getKey()));
                }
            }
        }
    }

    void killCursors(ServerAddress addr, List<Long> all) throws MongoException {
        if (all == null || all.size() == 0) {
            return;
        }
        OutMessage om = new OutMessage(this._mongo, 2007);
        om.writeInt(0);
        om.writeInt(Math.min(20000, all.size()));
        int soFar = 0;
        int totalSoFar = 0;
        for (Long l : all) {
            om.writeLong(l);
            ++totalSoFar;
            if (++soFar < 20000) continue;
            this._connector.say(this, om, WriteConcern.NONE);
            om = new OutMessage(this._mongo, 2007);
            om.writeInt(0);
            om.writeInt(Math.min(20000, all.size() - totalSoFar));
            soFar = 0;
        }
        this._connector.say(this, om, WriteConcern.NONE, addr);
    }

    static class DeadCursor {
        final long id;
        final ServerAddress host;

        DeadCursor(long a, ServerAddress b) {
            this.id = a;
            this.host = b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Result
    implements Iterator<DBObject> {
        Response _curResult;
        Iterator<DBObject> _cur;
        int _batchSize;
        int _limit;
        final MyCollection _collection;
        final int _options;
        final ServerAddress _host;
        private long _totalBytes = 0L;
        private int _numGetMores = 0;
        private List<Integer> _sizes = new ArrayList<Integer>();
        private int _numFetched = 0;

        Result(MyCollection coll, Response res, int batchSize, int limit, int options) {
            this._collection = coll;
            this._batchSize = batchSize;
            this._limit = limit;
            this._options = options;
            this._host = res._host;
            this.init(res);
        }

        private void init(Response res) {
            this._totalBytes += (long)res._len;
            this._curResult = res;
            this._cur = res.iterator();
            this._sizes.add(res.size());
            this._numFetched += res.size();
            if ((res._flags & 1) > 0) {
                throw new MongoException.CursorNotFound();
            }
            if (res._cursor != 0L && this._limit > 0 && this._limit - this._numFetched <= 0) {
                this.killCursor();
            }
        }

        @Override
        public DBObject next() {
            if (this._cur.hasNext()) {
                return this._cur.next();
            }
            if (!this._curResult.hasGetMore(this._options)) {
                throw new RuntimeException("no more");
            }
            this._advance();
            return this.next();
        }

        @Override
        public boolean hasNext() {
            while (!this._cur.hasNext()) {
                if (!this._curResult.hasGetMore(this._options)) {
                    return false;
                }
                this._advance();
            }
            return true;
        }

        private void _advance() {
            if (this._curResult.cursor() <= 0L) {
                throw new RuntimeException("can't advance a cursor <= 0");
            }
            OutMessage m = new OutMessage(DBApiLayer.this._mongo, 2005);
            m.writeInt(0);
            m.writeCString(this._collection._fullNameSpace);
            m.writeInt(DBApiLayer.chooseBatchSize(this._batchSize, this._limit, this._numFetched));
            m.writeLong(this._curResult.cursor());
            Response res = DBApiLayer.this._connector.call(DBApiLayer.this, this._collection, m, this._host);
            ++this._numGetMores;
            this.init(res);
        }

        @Override
        public void remove() {
            throw new RuntimeException("can't remove this way");
        }

        public int getBatchSize() {
            return this._batchSize;
        }

        public void setBatchSize(int size) {
            this._batchSize = size;
        }

        public String toString() {
            return "DBCursor";
        }

        protected void finalize() throws Throwable {
            if (this._curResult != null) {
                long curId = this._curResult.cursor();
                this._curResult = null;
                this._cur = null;
                if (curId != 0L) {
                    DBApiLayer.this._deadCursorIds.add(new DeadCursor(curId, this._host));
                }
            }
            super.finalize();
        }

        public long totalBytes() {
            return this._totalBytes;
        }

        public long getCursorId() {
            if (this._curResult == null) {
                return 0L;
            }
            return this._curResult._cursor;
        }

        int numGetMores() {
            return this._numGetMores;
        }

        List<Integer> getSizes() {
            return Collections.unmodifiableList(this._sizes);
        }

        void close() {
            if (this._curResult != null) {
                this.killCursor();
                this._curResult = null;
                this._cur = null;
            }
        }

        void killCursor() {
            if (this._curResult == null) {
                return;
            }
            long curId = this._curResult.cursor();
            if (curId == 0L) {
                return;
            }
            ArrayList<Long> l = new ArrayList<Long>();
            l.add(curId);
            try {
                DBApiLayer.this.killCursors(this._host, l);
            }
            catch (Throwable t) {
                Bytes.LOGGER.log(Level.WARNING, "can't clean 1 cursor", t);
                DBApiLayer.this._deadCursorIds.add(new DeadCursor(curId, this._host));
            }
            this._curResult._cursor = 0L;
        }

        public ServerAddress getServerAddress() {
            return this._host;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyCollection
    extends DBCollection {
        final String _fullNameSpace;

        MyCollection(String name) {
            super(DBApiLayer.this, name);
            this._fullNameSpace = DBApiLayer.this._root + "." + name;
        }

        @Override
        public void doapply(DBObject o) {
        }

        @Override
        public void drop() throws MongoException {
            DBApiLayer.this._collections.remove(this.getName());
            super.drop();
        }

        @Override
        public WriteResult insert(DBObject[] arr, WriteConcern concern) throws MongoException {
            return this.insert(arr, true, concern);
        }

        protected WriteResult insert(DBObject[] arr, boolean shouldApply, WriteConcern concern) throws MongoException {
            if (DBApiLayer.willTrace()) {
                for (DBObject o : arr) {
                    DBApiLayer.trace("save:  " + this._fullNameSpace + " " + JSON.serialize(o));
                }
            }
            if (shouldApply) {
                for (int i = 0; i < arr.length; ++i) {
                    DBObject o = arr[i];
                    this.apply(o);
                    this._checkObject(o, false, false);
                    Object id = o.get("_id");
                    if (!(id instanceof ObjectId)) continue;
                    ((ObjectId)id).notNew();
                }
            }
            WriteResult last = null;
            int cur = 0;
            int maxsize = DBApiLayer.this._mongo.getMaxBsonObjectSize();
            while (cur < arr.length) {
                OutMessage om = new OutMessage(DBApiLayer.this._mongo, 2002);
                om.writeInt(0);
                om.writeCString(this._fullNameSpace);
                while (cur < arr.length) {
                    DBObject o = arr[cur];
                    om.putObject(o);
                    if (om.size() > 2 * maxsize) {
                        ++cur;
                        break;
                    }
                    ++cur;
                }
                last = DBApiLayer.this._connector.say(this._db, om, concern);
            }
            return last;
        }

        @Override
        public WriteResult remove(DBObject o, WriteConcern concern) throws MongoException {
            if (DBApiLayer.willTrace()) {
                DBApiLayer.trace("remove: " + this._fullNameSpace + " " + JSON.serialize(o));
            }
            OutMessage om = new OutMessage(DBApiLayer.this._mongo, 2006);
            om.writeInt(0);
            om.writeCString(this._fullNameSpace);
            Set<String> keys = o.keySet();
            if (keys.size() == 1 && ((String)keys.iterator().next()).equals("_id") && o.get((String)keys.iterator().next()) instanceof ObjectId) {
                om.writeInt(1);
            } else {
                om.writeInt(0);
            }
            om.putObject(o);
            return DBApiLayer.this._connector.say(this._db, om, concern);
        }

        @Override
        Iterator<DBObject> __find(DBObject ref, DBObject fields, int numToSkip, int batchSize, int limit, int options) throws MongoException {
            DBObject foo;
            MongoException e;
            OutMessage query;
            Response res;
            if (ref == null) {
                ref = new BasicDBObject();
            }
            if (DBApiLayer.willTrace()) {
                DBApiLayer.trace("find: " + this._fullNameSpace + " " + JSON.serialize(ref));
            }
            if ((res = DBApiLayer.this._connector.call(this._db, this, query = OutMessage.query(DBApiLayer.this._mongo, options, this._fullNameSpace, numToSkip, DBApiLayer.chooseBatchSize(batchSize, limit, 0), ref, fields), null, 2)).size() == 0) {
                return null;
            }
            if (res.size() == 1 && (e = MongoException.parse(foo = res.get(0))) != null && !this._name.equals("$cmd")) {
                throw e;
            }
            return new Result(this, res, batchSize, limit, options);
        }

        @Override
        public WriteResult update(DBObject query, DBObject o, boolean upsert, boolean multi, WriteConcern concern) throws MongoException {
            String key;
            if (o != null && !o.keySet().isEmpty() && (key = o.keySet().iterator().next()).charAt(0) != '$') {
                this._checkObject(o, false, false);
            }
            if (DBApiLayer.willTrace()) {
                DBApiLayer.trace("update: " + this._fullNameSpace + " " + JSON.serialize(query) + " " + JSON.serialize(o));
            }
            OutMessage om = new OutMessage(DBApiLayer.this._mongo, 2001);
            om.writeInt(0);
            om.writeCString(this._fullNameSpace);
            int flags = 0;
            if (upsert) {
                flags |= 1;
            }
            if (multi) {
                flags |= 2;
            }
            om.writeInt(flags);
            om.putObject(query);
            om.putObject(o);
            return DBApiLayer.this._connector.say(this._db, om, concern);
        }

        @Override
        public void createIndex(DBObject keys, DBObject options) throws MongoException {
            BasicDBObject full = new BasicDBObject();
            for (String k : options.keySet()) {
                full.put(k, options.get(k));
            }
            full.put("key", (Object)keys);
            DBApiLayer.this.doGetCollection("system.indexes").insert(new DBObject[]{full}, false, WriteConcern.SAFE);
        }
    }
}

