/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class WriteConcern {
    public static final WriteConcern NONE = new WriteConcern(-1);
    public static final WriteConcern NORMAL = new WriteConcern(0);
    public static final WriteConcern SAFE = new WriteConcern(1);
    public static final WriteConcern FSYNC_SAFE = new WriteConcern(true);
    public static final WriteConcern REPLICAS_SAFE = new WriteConcern(2);
    private static Map<String, WriteConcern> _namedConcerns = null;
    final int _w;
    final int _wtimeout;
    final boolean _fsync;
    final BasicDBObject _command;

    public static WriteConcern valueOf(String name) {
        if (_namedConcerns == null) {
            HashMap<String, WriteConcern> newMap = new HashMap<String, WriteConcern>(8, 1.0f);
            for (Field f : WriteConcern.class.getFields()) {
                if (!Modifier.isStatic(f.getModifiers()) || !f.getType().equals(WriteConcern.class)) continue;
                try {
                    newMap.put(f.getName().toLowerCase(), (WriteConcern)f.get(null));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            _namedConcerns = newMap;
        }
        return _namedConcerns.get(name.toLowerCase());
    }

    public WriteConcern() {
        this(0);
    }

    public WriteConcern(int w) {
        this(w, 0, false);
    }

    public WriteConcern(int w, int wtimeout) {
        this(w, wtimeout, false);
    }

    public WriteConcern(boolean fsync) {
        this(1, 0, fsync);
    }

    public WriteConcern(int w, int wtimeout, boolean fsync) {
        this._w = w;
        this._wtimeout = wtimeout;
        this._fsync = fsync;
        this._command = new BasicDBObject("getlasterror", (Object)1);
        if (this._w > 0) {
            this._command.put("w", (Object)this._w);
            this._command.put("wtimeout", (Object)wtimeout);
        }
        if (this._fsync) {
            this._command.put("fsync", (Object)true);
        }
    }

    public BasicDBObject getCommand() {
        return this._command;
    }

    public int getW() {
        return this._w;
    }

    public int getWtimeout() {
        return this._wtimeout;
    }

    public boolean fsync() {
        return this._fsync;
    }

    public boolean raiseNetworkErrors() {
        return this._w >= 0;
    }

    public boolean callGetLastError() {
        return this._w > 0;
    }

    public String toString() {
        return "WriteConcern " + this._command;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteConcern that = (WriteConcern)o;
        if (this._fsync != that._fsync) {
            return false;
        }
        if (this._w != that._w) {
            return false;
        }
        return this._wtimeout == that._wtimeout;
    }
}

