/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.boot.impl;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.nio.charset.StandardCharsets;
import java.security.ProtectionDomain;
import org.netbeans.html.boot.impl.FnUtils;

public final class JsAgent
implements ClassFileTransformer {
    private static final byte[] PATTERN = new String("net/java/html/js/").getBytes(StandardCharsets.UTF_8);

    public static void premain(String args, Instrumentation instr) {
        instr.addTransformer(new JsAgent());
    }

    public static void agentmain(String args, Instrumentation instr) {
        instr.addTransformer(new JsAgent());
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            if (JsAgent.containsJavaBodies(classfileBuffer)) {
                return FnUtils.transform(classfileBuffer, loader, true);
            }
            return classfileBuffer;
        }
        catch (Error | Exception ex) {
            System.err.println("Error transforming " + className);
            ex.printStackTrace();
            return classfileBuffer;
        }
    }

    private static boolean containsJavaBodies(byte[] arr) {
        block0: for (int i = 0; i < arr.length - PATTERN.length; ++i) {
            for (int j = 0; j < PATTERN.length; ++j) {
                if (arr[i + j] != PATTERN[j]) continue block0;
            }
            return true;
        }
        return false;
    }
}

