/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.java_kcp;

import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.net.InetSocketAddress;
import kcp.Ukcp;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.java_kcp.impl.NettyBufferCodecWriter;

public class KcpNioChannelAssistant
implements ChannelAssistant<Ukcp> {
    private final Config config;

    public KcpNioChannelAssistant(Config config) {
        this.config = config;
    }

    public void write(Ukcp target, Frame frame) throws IOException {
        if (frame != null) {
            NettyBufferCodecWriter writer = (NettyBufferCodecWriter)this.config.getCodec().write(frame, i -> new NettyBufferCodecWriter(Unpooled.buffer((int)i)));
            target.write(writer.getBuffer());
            writer.getBuffer().release();
        }
    }

    public boolean isValid(Ukcp target) {
        return target.isActive();
    }

    public void close(Ukcp target) throws IOException {
        target.close();
    }

    public InetSocketAddress getRemoteAddress(Ukcp target) throws IOException {
        return target.user().getRemoteAddress();
    }

    public InetSocketAddress getLocalAddress(Ukcp target) throws IOException {
        return null;
    }
}

