/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.java_kcp;

import com.backblaze.erasure.FecAdapt;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kcp.ChannelConfig;
import kcp.KcpClient;
import kcp.KcpListener;
import kcp.Ukcp;
import org.noear.socketd.exception.SocketdConnectionException;
import org.noear.socketd.exception.SocketdTimeoutException;
import org.noear.socketd.transport.client.ClientConnectorBase;
import org.noear.socketd.transport.client.ClientHandshakeResult;
import org.noear.socketd.transport.client.ClientInternal;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.java_kcp.KcpNioClient;
import org.noear.socketd.transport.java_kcp.impl.ClientKcpListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KcpNioClientConnector
extends ClientConnectorBase<KcpNioClient> {
    private static final Logger log = LoggerFactory.getLogger(KcpNioClientConnector.class);
    private Ukcp real;

    public KcpNioClientConnector(KcpNioClient client) {
        super((ClientInternal)client);
    }

    public ChannelInternal connect() throws IOException {
        this.close();
        ChannelConfig channelConfig = new ChannelConfig();
        channelConfig.nodelay(true, 40, 2, true);
        channelConfig.setSndwnd(512);
        channelConfig.setRcvwnd(512);
        channelConfig.setMtu(512);
        channelConfig.setAckNoDelay(true);
        channelConfig.setConv(Math.abs(new Random().nextInt()));
        channelConfig.setFecAdapt(new FecAdapt(3, 1));
        channelConfig.setCrc32Check(true);
        if (((KcpNioClient)this.client).getConfig().getIdleTimeout() > 0L) {
            channelConfig.setTimeoutMillis(((KcpNioClient)this.client).getConfig().getIdleTimeout());
        }
        KcpClient kcpClient = new KcpClient();
        kcpClient.init(channelConfig);
        ClientKcpListener kcpListener = new ClientKcpListener((KcpNioClient)this.client);
        InetSocketAddress kcpAddress = new InetSocketAddress(((KcpNioClient)this.client).getConfig().getHost(), ((KcpNioClient)this.client).getConfig().getPort());
        try {
            this.real = kcpClient.connect(kcpAddress, channelConfig, (KcpListener)kcpListener);
            ClientHandshakeResult handshakeResult = kcpListener.getHandshakeFuture().get(((KcpNioClient)this.client).getConfig().getConnectTimeout(), TimeUnit.MILLISECONDS);
            if (handshakeResult.getThrowable() != null) {
                throw handshakeResult.getThrowable();
            }
            return handshakeResult.getChannel();
        }
        catch (TimeoutException e) {
            this.close();
            throw new SocketdTimeoutException("Connection timeout: " + ((KcpNioClient)this.client).getConfig().getLinkUrl());
        }
        catch (Throwable e) {
            this.close();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new SocketdConnectionException("Connection failed: " + ((KcpNioClient)this.client).getConfig().getLinkUrl(), e);
        }
    }

    public void close() {
        try {
            if (this.real != null) {
                this.real.close();
            }
        }
        catch (Throwable e) {
            log.debug("{}", e);
        }
    }
}

