/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.java_kcp;

import com.backblaze.erasure.FecAdapt;
import java.io.IOException;
import kcp.ChannelConfig;
import kcp.KcpListener;
import kcp.KcpServer;
import kcp.Ukcp;
import org.noear.socketd.SocketD;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.ChannelSupporter;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.java_kcp.KcpNioChannelAssistant;
import org.noear.socketd.transport.java_kcp.impl.ServerKcpListener;
import org.noear.socketd.transport.server.Server;
import org.noear.socketd.transport.server.ServerBase;
import org.noear.socketd.transport.server.ServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KcpNioServer
extends ServerBase<KcpNioChannelAssistant>
implements ChannelSupporter<Ukcp> {
    private static final Logger log = LoggerFactory.getLogger(KcpNioServer.class);
    private KcpServer server;

    public KcpNioServer(ServerConfig config) {
        super(config, (ChannelAssistant)new KcpNioChannelAssistant((Config)config));
    }

    public String getTitle() {
        return "kcp/nio/java-kcp/" + SocketD.version();
    }

    public Server start() throws IOException {
        if (this.isStarted) {
            throw new IllegalStateException("Socket.D server started");
        }
        this.isStarted = true;
        ChannelConfig channelConfig = new ChannelConfig();
        channelConfig.nodelay(true, 40, 2, true);
        channelConfig.setSndwnd(512);
        channelConfig.setRcvwnd(512);
        channelConfig.setMtu(512);
        channelConfig.setFecAdapt(new FecAdapt(3, 1));
        channelConfig.setAckNoDelay(true);
        channelConfig.setUseConvChannel(true);
        channelConfig.setCrc32Check(true);
        if (this.getConfig().getIdleTimeout() > 0L) {
            channelConfig.setTimeoutMillis(this.getConfig().getIdleTimeout());
        }
        this.server = new KcpServer();
        this.server.init((KcpListener)new ServerKcpListener(this), channelConfig, new int[]{this.getConfig().getPort()});
        log.info("Socket.D server started: {server=" + this.getConfig().getLocalUrl() + "}");
        return this;
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
    }
}

