/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.java_kcp.impl;

import io.netty.buffer.ByteBuf;
import java.util.concurrent.CompletableFuture;
import kcp.KcpListener;
import kcp.Ukcp;
import org.noear.socketd.transport.client.ClientHandshakeResult;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.ChannelSupporter;
import org.noear.socketd.transport.core.CodecReader;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.impl.ChannelDefault;
import org.noear.socketd.transport.java_kcp.KcpNioClient;
import org.noear.socketd.transport.java_kcp.impl.NettyBufferCodecReader;

public class ClientKcpListener
implements KcpListener {
    private final KcpNioClient client;
    private final CompletableFuture<ClientHandshakeResult> handshakeFuture = new CompletableFuture();

    public CompletableFuture<ClientHandshakeResult> getHandshakeFuture() {
        return this.handshakeFuture;
    }

    public ClientKcpListener(KcpNioClient client) {
        this.client = client;
    }

    public void onConnected(Ukcp ukcp) {
        ChannelDefault channel = new ChannelDefault((Object)ukcp, (ChannelSupporter)this.client);
        ukcp.user().setCache((Object)channel);
        try {
            channel.sendConnect(this.client.getConfig().getUrl(), this.client.getConfig().getMetaMap());
        }
        catch (Throwable e) {
            channel.onError(e);
        }
    }

    public void handleReceive(ByteBuf byteBuf, Ukcp ukcp) {
        NettyBufferCodecReader reader = new NettyBufferCodecReader(byteBuf);
        Frame frame = this.client.getConfig().getCodec().read((CodecReader)reader);
        if (frame == null) {
            return;
        }
        ChannelInternal channel = (ChannelInternal)ukcp.user().getCache();
        try {
            if (frame.flag() == 11) {
                channel.onOpenFuture((r, e) -> this.handshakeFuture.complete(new ClientHandshakeResult(channel, e)));
            }
            this.client.getProcessor().onReceive(channel, frame);
        }
        catch (Throwable e2) {
            this.client.getProcessor().onError(channel, e2);
            this.handshakeFuture.complete(new ClientHandshakeResult(channel, e2));
        }
    }

    public void handleException(Throwable throwable, Ukcp ukcp) {
        ChannelInternal channel = (ChannelInternal)ukcp.user().getCache();
        this.client.getProcessor().onError(channel, throwable);
    }

    public void handleClose(Ukcp ukcp) {
        ChannelInternal channel = (ChannelInternal)ukcp.user().getCache();
        this.client.getProcessor().onClose(channel);
    }
}

