/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.java_kcp.impl;

import io.netty.buffer.ByteBuf;
import kcp.KcpListener;
import kcp.Ukcp;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.ChannelSupporter;
import org.noear.socketd.transport.core.CodecReader;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.impl.ChannelDefault;
import org.noear.socketd.transport.java_kcp.KcpNioServer;
import org.noear.socketd.transport.java_kcp.impl.NettyBufferCodecReader;

public class ServerKcpListener
implements KcpListener {
    private final KcpNioServer server;

    public ServerKcpListener(KcpNioServer server) {
        this.server = server;
    }

    public void onConnected(Ukcp ukcp) {
        ChannelDefault channel = new ChannelDefault((Object)ukcp, (ChannelSupporter)this.server);
        ukcp.user().setCache((Object)channel);
    }

    public void handleReceive(ByteBuf byteBuf, Ukcp ukcp) {
        NettyBufferCodecReader reader = new NettyBufferCodecReader(byteBuf);
        Frame frame = this.server.getConfig().getCodec().read((CodecReader)reader);
        if (frame == null) {
            return;
        }
        ChannelInternal channel = (ChannelInternal)ukcp.user().getCache();
        try {
            this.server.getProcessor().onReceive(channel, frame);
        }
        catch (Throwable e) {
            this.server.getProcessor().onError(channel, e);
        }
    }

    public void handleException(Throwable throwable, Ukcp ukcp) {
        ChannelInternal channel = (ChannelInternal)ukcp.user().getCache();
        this.server.getProcessor().onError(channel, throwable);
    }

    public void handleClose(Ukcp ukcp) {
        ChannelInternal channel = (ChannelInternal)ukcp.user().getCache();
        this.server.getProcessor().onClose(channel);
    }
}

