/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.java_tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import org.noear.socketd.SocketD;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.ChannelInternal;
import org.noear.socketd.transport.core.ChannelSupporter;
import org.noear.socketd.transport.core.Config;
import org.noear.socketd.transport.core.Frame;
import org.noear.socketd.transport.core.impl.ChannelDefault;
import org.noear.socketd.transport.java_tcp.TcpBioChannelAssistant;
import org.noear.socketd.transport.server.Server;
import org.noear.socketd.transport.server.ServerBase;
import org.noear.socketd.transport.server.ServerConfig;
import org.noear.socketd.utils.RunUtils;
import org.noear.socketd.utils.StrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpBioServer
extends ServerBase<TcpBioChannelAssistant>
implements ChannelSupporter<Socket> {
    private static final Logger log = LoggerFactory.getLogger(TcpBioServer.class);
    private ServerSocket server;
    private ExecutorService serverExecutor;

    public TcpBioServer(ServerConfig config) {
        super(config, (ChannelAssistant)new TcpBioChannelAssistant((Config)config));
    }

    private ServerSocket createServer() throws IOException {
        if (this.getConfig().getSslContext() == null) {
            if (StrUtils.isEmpty((String)this.getConfig().getHost())) {
                return new ServerSocket(this.getConfig().getPort());
            }
            return new ServerSocket(this.getConfig().getPort(), 50, InetAddress.getByName(this.getConfig().getHost()));
        }
        if (StrUtils.isEmpty((String)this.getConfig().getHost())) {
            return this.getConfig().getSslContext().getServerSocketFactory().createServerSocket(this.getConfig().getPort());
        }
        return this.getConfig().getSslContext().getServerSocketFactory().createServerSocket(this.getConfig().getPort(), 50, InetAddress.getByName(this.getConfig().getHost()));
    }

    public String getTitle() {
        return "tcp/bio/java-tcp/" + SocketD.version();
    }

    public Server start() throws IOException {
        if (this.isStarted) {
            throw new IllegalStateException("Socket.D server started");
        }
        this.isStarted = true;
        this.serverExecutor = Executors.newFixedThreadPool(this.getConfig().getMaxThreads());
        this.server = this.createServer();
        this.serverExecutor.submit(this::accept);
        log.info("Socket.D server started: {server=" + this.getConfig().getLocalUrl() + "}");
        return this;
    }

    private void accept() {
        while (true) {
            Socket socketTmp = null;
            try {
                Socket socket = socketTmp = this.server.accept();
                if (this.getConfig().getIdleTimeout() > 0L) {
                    socket.setSoTimeout((int)this.getConfig().getIdleTimeout());
                }
                if (this.getConfig().getReadBufferSize() > 0) {
                    socket.setReceiveBufferSize(this.getConfig().getReadBufferSize());
                }
                if (this.getConfig().getWriteBufferSize() > 0) {
                    socket.setSendBufferSize(this.getConfig().getWriteBufferSize());
                }
                this.serverExecutor.submit(() -> {
                    try {
                        ChannelDefault channel = new ChannelDefault((Object)socket, (ChannelSupporter)this);
                        this.receive((ChannelInternal)channel, socket);
                    }
                    catch (Throwable e) {
                        if (log.isWarnEnabled()) {
                            log.warn("Server receive error", e);
                        }
                        this.close(socket);
                    }
                });
                continue;
            }
            catch (RejectedExecutionException e) {
                if (socketTmp == null) continue;
                log.warn("Server thread pool is full", (Throwable)e);
                RunUtils.runAndTry(socketTmp::close);
                continue;
            }
            catch (Throwable e) {
                if (this.server.isClosed()) {
                    return;
                }
                log.warn("Server accept error", e);
                continue;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void receive(ChannelInternal channel, Socket socket) {
        while (true) {
            try {
                try {
                    while (true) {
                        if (socket.isClosed()) {
                            this.getProcessor().onClose(channel);
                            return;
                        }
                        Frame frame = ((TcpBioChannelAssistant)this.getAssistant()).read(socket);
                        if (frame == null) continue;
                        this.getProcessor().onReceive(channel, frame);
                    }
                }
                catch (SocketTimeoutException e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Server channel idle timeout, remoteIp={}", (Object)socket.getRemoteSocketAddress());
                    }
                    channel.sendClose();
                    throw e;
                }
            }
            catch (IOException e) {
                this.getProcessor().onError(channel, (Throwable)e);
                this.getProcessor().onClose(channel);
                this.close(socket);
                return;
            }
            catch (Throwable e) {
                this.getProcessor().onError(channel, e);
                continue;
            }
            break;
        }
    }

    private void close(Socket socket) {
        try {
            socket.close();
        }
        catch (Throwable e) {
            log.debug("Server socket close error", e);
        }
    }

    public void stop() {
        if (!this.isStarted) {
            return;
        }
        this.isStarted = false;
        try {
            if (this.server != null) {
                this.server.close();
            }
            if (this.serverExecutor != null) {
                this.serverExecutor.shutdown();
            }
        }
        catch (Exception e) {
            log.debug("Server stop error", (Throwable)e);
        }
    }
}

