/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.broker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.utils.StrUtils;

public abstract class BrokerListenerBase
implements Listener {
    private Map<String, Set<Session>> playerSessions = new ConcurrentHashMap<String, Set<Session>>();
    private AtomicInteger playerRoundCounter = new AtomicInteger(0);

    public Collection<String> getNameAll() {
        return this.playerSessions.keySet();
    }

    public int getPlayerNum(String name) {
        Collection<Session> tmp = this.getPlayerAll(name);
        if (tmp == null) {
            return 0;
        }
        return tmp.size();
    }

    public Collection<Session> getPlayerAll(String name) {
        return this.playerSessions.get(name);
    }

    public Session getPlayerOne(String name) {
        if (StrUtils.isEmpty(name)) {
            return null;
        }
        Session session = this.getPlayerOneDo(name);
        if (session != null && !session.isValid()) {
            this.onClose(session);
            session = this.getPlayerOneDo(name);
        }
        return session;
    }

    private Session getPlayerOneDo(String name) {
        Collection<Session> tmp = this.getPlayerAll(name);
        if (tmp == null || tmp.size() == 0) {
            return null;
        }
        ArrayList<Session> sessions = new ArrayList<Session>(tmp);
        if (sessions.size() == 1) {
            return (Session)sessions.get(0);
        }
        int counter = this.playerRoundCounter.incrementAndGet();
        int idx = counter % sessions.size();
        if (counter > 999999999) {
            this.playerRoundCounter.set(0);
        }
        return (Session)sessions.get(idx);
    }

    public void addPlayer(String name, Session session) {
        if (StrUtils.isNotEmpty(name)) {
            Set sessions = this.playerSessions.computeIfAbsent(name, n -> Collections.newSetFromMap(new ConcurrentHashMap()));
            sessions.add(session);
        }
    }

    public void removePlayer(String name, Session session) {
        Collection<Session> sessions;
        if (StrUtils.isNotEmpty(name) && (sessions = this.getPlayerAll(name)) != null) {
            sessions.remove(session);
        }
    }
}

