/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.client;

import java.io.IOException;
import org.noear.socketd.exception.SocketdException;
import org.noear.socketd.transport.client.Client;
import org.noear.socketd.transport.client.ClientChannel;
import org.noear.socketd.transport.client.ClientConfig;
import org.noear.socketd.transport.client.ClientConfigHandler;
import org.noear.socketd.transport.client.ClientConnector;
import org.noear.socketd.transport.client.ClientInternal;
import org.noear.socketd.transport.client.ClientSession;
import org.noear.socketd.transport.core.ChannelAssistant;
import org.noear.socketd.transport.core.HeartbeatHandler;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.transport.core.Processor;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.core.impl.ProcessorDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientBase<T extends ChannelAssistant>
implements ClientInternal {
    private static final Logger log = LoggerFactory.getLogger(ClientBase.class);
    protected Processor processor = new ProcessorDefault();
    protected HeartbeatHandler heartbeatHandler;
    private final ClientConfig config;
    private final T assistant;

    public ClientBase(ClientConfig clientConfig, T assistant) {
        this.config = clientConfig;
        this.assistant = assistant;
    }

    public T getAssistant() {
        return this.assistant;
    }

    @Override
    public HeartbeatHandler getHeartbeatHandler() {
        return this.heartbeatHandler;
    }

    @Override
    public long getHeartbeatInterval() {
        return this.config.getHeartbeatInterval();
    }

    @Override
    public ClientConfig getConfig() {
        return this.config;
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public Client heartbeatHandler(HeartbeatHandler handler) {
        if (handler != null) {
            this.heartbeatHandler = handler;
        }
        return this;
    }

    @Override
    public Client config(ClientConfigHandler configHandler) {
        if (configHandler != null) {
            configHandler.clientConfig(this.config);
        }
        return this;
    }

    @Override
    public Client listen(Listener listener) {
        if (listener != null) {
            this.processor.setListener(listener);
        }
        return this;
    }

    @Override
    public ClientSession open() throws IOException {
        return this.openDo(false);
    }

    @Override
    public ClientSession openOrThow() throws IOException {
        return this.openDo(true);
    }

    private Session openDo(boolean isThow) throws IOException {
        ClientConnector connector = this.createConnector();
        ClientChannel clientChannel = new ClientChannel(connector);
        try {
            clientChannel.connect();
            log.info("Socket.D client successfully connected: {link={}}", (Object)this.getConfig().getLinkUrl());
        }
        catch (Throwable e) {
            if (isThow) {
                clientChannel.close(28);
                if (e instanceof RuntimeException || e instanceof IOException) {
                    throw e;
                }
                throw new SocketdException("Socket.D client Connection failed", e);
            }
            log.info("Socket.D client Connection failed: {link={}}", (Object)this.getConfig().getLinkUrl());
        }
        return clientChannel.getSession();
    }

    protected abstract ClientConnector createConnector();
}

