/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.client;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.socketd.transport.core.impl.ConfigBase;

public class ClientConfig
extends ConfigBase<ClientConfig> {
    private final String schema;
    private final String linkUrl;
    private final String url;
    private final String host;
    private final int port;
    private final Map<String, String> metaMap = new LinkedHashMap<String, String>();
    private long heartbeatInterval;
    private long connectTimeout;
    private boolean autoReconnect;

    public ClientConfig(String url) {
        super(true);
        if (url.startsWith("sd:")) {
            url = url.substring(3);
        }
        URI uri = URI.create(url);
        this.linkUrl = "sd:" + url;
        this.url = url;
        this.host = uri.getHost();
        this.port = uri.getPort() < 0 ? 8602 : uri.getPort();
        this.schema = uri.getScheme();
        this.connectTimeout = 10000L;
        this.heartbeatInterval = 20000L;
        this.autoReconnect = true;
    }

    public String getLinkUrl() {
        return this.linkUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Map<String, String> getMetaMap() {
        return this.metaMap;
    }

    public ClientConfig metaPut(String name, String val) {
        this.metaMap.put(name, val);
        return this;
    }

    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public ClientConfig heartbeatInterval(long heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
        return this;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public ClientConfig connectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public ClientConfig autoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
        return this;
    }

    @Override
    public ClientConfig idleTimeout(int idleTimeout) {
        if (!this.autoReconnect) {
            return (ClientConfig)super.idleTimeout(idleTimeout);
        }
        return (ClientConfig)super.idleTimeout(0);
    }

    public String toString() {
        return "ClientConfig{schema='" + this.schema + '\'' + ", charset=" + this.charset + ", url='" + this.url + '\'' + ", heartbeatInterval=" + this.heartbeatInterval + ", connectTimeout=" + this.connectTimeout + ", idleTimeout=" + this.idleTimeout + ", requestTimeout=" + this.requestTimeout + ", readBufferSize=" + this.readBufferSize + ", writeBufferSize=" + this.writeBufferSize + ", autoReconnect=" + this.autoReconnect + ", maxUdpSize=" + this.maxUdpSize + '}';
    }
}

