/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.impl;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.socketd.transport.core.Handshake;
import org.noear.socketd.transport.core.HandshakeInternal;
import org.noear.socketd.transport.core.MessageInternal;
import org.noear.socketd.utils.StrUtils;

public class HandshakeDefault
implements HandshakeInternal {
    private final MessageInternal source;
    private final URI uri;
    private final String path;
    private final String version;
    private final Map<String, String> paramMap;

    @Override
    public MessageInternal getSource() {
        return this.source;
    }

    public HandshakeDefault(MessageInternal source) {
        String linkUrl = source.dataAsString();
        if (StrUtils.isEmpty(linkUrl)) {
            linkUrl = source.event();
        }
        this.source = source;
        this.uri = URI.create(linkUrl);
        this.path = this.uri.getPath();
        this.version = source.meta("Socket.D");
        this.paramMap = new ConcurrentHashMap<String, String>();
        String queryString = this.uri.getQuery();
        if (StrUtils.isNotEmpty(queryString)) {
            for (String kvStr : queryString.split("&")) {
                int idx = kvStr.indexOf(61);
                if (idx <= 0) continue;
                this.paramMap.put(kvStr.substring(0, idx), kvStr.substring(idx + 1));
            }
        }
        this.paramMap.putAll(source.metaMap());
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public Map<String, String> paramMap() {
        return this.paramMap;
    }

    @Override
    public String param(String name) {
        return this.paramMap.get(name);
    }

    @Override
    public String paramOrDefault(String name, String def) {
        return this.paramMap.getOrDefault(name, def);
    }

    @Override
    public Handshake paramPut(String name, String value) {
        this.paramMap.put(name, value);
        return this;
    }
}

