/*
 * Decompiled with CFR 0.152.
 */
package org.noear.socketd.transport.core.listener;

import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.transport.core.Message;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.core.listener.MessageHandler;
import org.noear.socketd.transport.core.listener.RouteSelector;
import org.noear.socketd.transport.core.listener.RouteSelectorDefault;
import org.noear.socketd.utils.IoConsumer;

public class EventListener
implements Listener {
    private IoConsumer<Session> doOnOpenHandler;
    private MessageHandler doOnMessageHandler;
    private Consumer<Session> doOnCloseHandler;
    private BiConsumer<Session, Throwable> doOnErrorHandler;
    private final RouteSelector<MessageHandler> eventRouteSelector;

    public EventListener() {
        this.eventRouteSelector = new RouteSelectorDefault<MessageHandler>();
    }

    public EventListener(RouteSelector<MessageHandler> routeSelector) {
        this.eventRouteSelector = routeSelector;
    }

    public EventListener doOnOpen(IoConsumer<Session> onOpen) {
        this.doOnOpenHandler = onOpen;
        return this;
    }

    public EventListener doOnMessage(MessageHandler onMessage) {
        this.doOnMessageHandler = onMessage;
        return this;
    }

    public EventListener doOnClose(Consumer<Session> onClose) {
        this.doOnCloseHandler = onClose;
        return this;
    }

    public EventListener doOnError(BiConsumer<Session, Throwable> onError) {
        this.doOnErrorHandler = onError;
        return this;
    }

    public EventListener doOn(String event, MessageHandler handler) {
        this.eventRouteSelector.put(event, handler);
        return this;
    }

    @Override
    public void onOpen(Session session) throws IOException {
        if (this.doOnOpenHandler != null) {
            this.doOnOpenHandler.accept(session);
        }
    }

    @Override
    public void onMessage(Session session, Message message) throws IOException {
        MessageHandler messageHandler;
        if (this.doOnMessageHandler != null) {
            this.doOnMessageHandler.handle(session, message);
        }
        if ((messageHandler = this.eventRouteSelector.select(message.event())) != null) {
            messageHandler.handle(session, message);
        }
    }

    @Override
    public void onClose(Session session) {
        if (this.doOnCloseHandler != null) {
            this.doOnCloseHandler.accept(session);
        }
    }

    @Override
    public void onError(Session session, Throwable error) {
        if (this.doOnErrorHandler != null) {
            this.doOnErrorHandler.accept(session, error);
        }
    }
}

