/*
 * Decompiled with CFR 0.152.
 */
package org.objectfabric;

import java.io.File;
import org.objectfabric.Address;
import org.objectfabric.Clock;
import org.objectfabric.JVMPlatform;
import org.objectfabric.Location;
import org.objectfabric.Origin;
import org.objectfabric.SHA1Digest;
import org.objectfabric.SQLiteClock;
import org.objectfabric.SQLiteLoop;
import org.objectfabric.SQLiteQueue;
import org.objectfabric.SQLiteView;
import org.objectfabric.URI;
import org.objectfabric.URIHandler;
import org.objectfabric.View;
import org.objectfabric.Watcher;

public class SQLite
extends Origin
implements URIHandler {
    private final File _file;
    private final SQLiteQueue _queue;
    private final SQLiteLoop _readers;
    private final SQLiteLoop _writer;

    public SQLite(String path, boolean cache) {
        this(new File(path), cache);
    }

    public SQLite(File file, boolean cache) {
        this(file, cache, 1);
    }

    public SQLite(File file, boolean cache, int readers) {
        super(cache);
        this._file = file;
        this._queue = new SQLiteQueue(this);
        this._readers = new SQLiteLoop(this, readers, false);
        this._writer = new SQLiteLoop(this, 1, true);
    }

    public final File file() {
        return this._file;
    }

    public void close() {
        this._queue.requestClose(null);
        this._readers.close();
        this._writer.close();
    }

    final SQLiteQueue queue() {
        return this._queue;
    }

    final SQLiteLoop readers() {
        return this._readers;
    }

    final SQLiteLoop writer() {
        return this._writer;
    }

    View newView(URI uri) {
        SHA1Digest digest = new SHA1Digest();
        uri.origin().sha1(digest);
        digest.update(uri.path());
        byte[] sha1 = new byte[20];
        digest.doFinal(sha1, 0);
        return new SQLiteView((Location)this, sha1);
    }

    Clock newClock(Watcher watcher) {
        return new SQLiteClock(watcher, this);
    }

    public URI handle(Address address, String path) {
        return this.getURI(path);
    }

    public String toString() {
        return "SQLite";
    }

    static {
        JVMPlatform.loadClass();
    }
}

