/*
 * Decompiled with CFR 0.152.
 */
package org.objectfabric;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import org.objectfabric.Actor;
import org.objectfabric.Buff;
import org.objectfabric.Clock;
import org.objectfabric.Location;
import org.objectfabric.Peer;
import org.objectfabric.Platform;
import org.objectfabric.Resource;
import org.objectfabric.Resources;
import org.objectfabric.SQLite;
import org.objectfabric.SQLiteLoop;
import org.objectfabric.SQLiteView;
import org.objectfabric.Tick;
import org.objectfabric.UID;
import org.objectfabric.Watcher;

final class SQLiteClock
extends Clock {
    private final SQLite _location;

    SQLiteClock(Watcher watcher, SQLite location) {
        super(watcher);
        this._location = location;
    }

    void writing(Resources resources) {
        final long[][] loaded = new long[resources.size()][];
        for (int i = 0; i < resources.size(); ++i) {
            loaded[i] = Platform.get().clone(resources.get(i).loaded());
        }
        this._location.writer().add(new SQLiteLoop.Query(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void run(SQLiteConnection db) throws SQLiteException {
                SQLiteStatement st = db.prepare("SELECT * FROM clocks");
                Peer peer = null;
                long time = 0L;
                long object = 0L;
                boolean foundOne = false;
                try {
                    while (st.step()) {
                        peer = Peer.get((UID)new UID(st.columnBlob(0)));
                        time = st.columnLong(1);
                        object = st.columnLong(2);
                        long tick = Tick.get((int)peer.index(), (long)time);
                        if (!SQLiteClock.this.upToDate(loaded, tick)) continue;
                        foundOne = true;
                        break;
                    }
                }
                finally {
                    st.dispose();
                }
                if (!foundOne) {
                    peer = Peer.get((UID)new UID(Platform.get().newUID()));
                    time = Clock.time((long)0L, (boolean)false);
                    object = 0L;
                }
                SQLiteClock.this._location.writer().walks().put(peer, peer);
                final Peer peer_ = peer;
                final long time_ = time;
                final long object_ = object;
                SQLiteClock.this.watcher().actor().addAndRun(new Actor.Message(){

                    void run() {
                        SQLiteClock.this.watcher().clock().init(peer_, Clock.time((long)time_, (boolean)true), object_);
                    }
                });
            }
        });
    }

    private final boolean upToDate(long[][] loaded, long tick) {
        for (int i = 0; i < loaded.length; ++i) {
            if (Tick.happenedBefore((long)tick, (long[])loaded[i])) continue;
            return false;
        }
        return true;
    }

    void commit() {
        if (this.blocks().size() > 0) {
            final Resource.NewBlock[] blocks = new Resource.NewBlock[this.blocks().size()];
            final Buff[][] duplicates = new Buff[blocks.length][];
            for (int i = blocks.length - 1; i >= 0; --i) {
                blocks[i] = (Resource.NewBlock)this.blocks().removeLast();
                duplicates[i] = new Buff[blocks[i].Buffs.length];
                for (int d = 0; d < blocks[i].Buffs.length; ++d) {
                    duplicates[i][d] = blocks[i].Buffs[d].duplicate();
                }
            }
            final Peer peer = this.peer();
            final long time = this.time();
            final long object = this.object();
            this.init(null, 0L, 0L);
            this._location.writer().add(new SQLiteLoop.Query(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                void run(SQLiteConnection db) throws SQLiteException {
                    SQLiteStatement st = db.prepare("REPLACE INTO clocks VALUES (?, ?, ?)");
                    try {
                        st.bind(1, peer.uid());
                        st.bind(2, time);
                        st.bind(3, object);
                        st.step();
                    }
                    finally {
                        st.dispose();
                    }
                    for (int i = 0; i < blocks.length; ++i) {
                        SQLiteClock.this._location.queue().write(db, blocks[i].Resource.uri(), blocks[i].Tick, duplicates[i], blocks[i].Removals);
                    }
                    SQLiteClock.this._location.writer().walks().remove(peer);
                }

                @Override
                void ack() {
                    SQLiteClock.this.watcher().actor().addAndRun(new Actor.Message(){

                        void run() {
                            for (int i = 0; i < blocks.length; ++i) {
                                SQLiteView view = (SQLiteView)blocks[i].Resource.uri().getOrCreate((Location)SQLiteClock.this._location);
                                view.add(blocks[i].Tick, blocks[i].Removals);
                                Clock.publish((Resource)blocks[i].Resource, (long)blocks[i].Tick, (Buff[])duplicates[i], (long[])blocks[i].Removals, (Location)SQLiteClock.this._location);
                                for (int d = 0; d < duplicates[i].length; ++d) {
                                    duplicates[i][d].recycle();
                                }
                                blocks[i].Resource.ack((Location)SQLiteClock.this._location, blocks[i].Tick);
                            }
                        }
                    });
                }
            });
        }
    }
}

