/*
 * Decompiled with CFR 0.152.
 */
package org.objectfabric;

import com.almworks.sqlite4java.SQLiteBusyException;
import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.objectfabric.List;
import org.objectfabric.Log;
import org.objectfabric.Peer;
import org.objectfabric.SQLite;

final class SQLiteLoop {
    private static final int MAX_BATCH = 100;
    private final SQLite _location;
    private final Run[] _runs;
    private final LinkedBlockingQueue<Query> _queue = new LinkedBlockingQueue();
    private final AtomicInteger _ongoing;
    private final HashMap<Peer, Peer> _walks;
    private volatile boolean _running = true;

    SQLiteLoop(SQLite location, int threads, boolean count) {
        this._location = location;
        this._runs = new Run[threads];
        for (int i = 0; i < threads; ++i) {
            this._runs[i] = new Run();
            this._runs[i].start();
        }
        if (count) {
            this._ongoing = new AtomicInteger();
            this._walks = new HashMap();
        } else {
            this._ongoing = null;
            this._walks = null;
        }
    }

    final void close() {
        this._running = false;
        for (int i = 0; i < this._runs.length; ++i) {
            this._runs[i].interrupt();
            try {
                this._runs[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    final int room() {
        return 100 - this._ongoing.get();
    }

    final void add(Query query) {
        this._queue.offer(query);
        if (this._ongoing != null) {
            this._ongoing.addAndGet(query.statements());
        }
    }

    final HashMap<Peer, Peer> walks() {
        return this._walks;
    }

    private final class Run
    extends Thread {
        Run() {
            this.setName("SQLiteQueue");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SQLiteConnection db = new SQLiteConnection(SQLiteLoop.this._location.file());
            List toAck = new List();
            try {
                db.open(true);
                while (true) {
                    try {
                        db.exec("CREATE TABLE IF NOT EXISTS blocks (sha1 BLOB NOT NULL, time INTEGER NOT NULL, peer BLOB NOT NULL, block BLOB NOT NULL);CREATE UNIQUE INDEX IF NOT EXISTS blocks_index ON blocks (sha1, time, peer);CREATE TABLE IF NOT EXISTS clocks (peer BLOB NOT NULL PRIMARY KEY, time INTEGER NOT NULL, object INTEGER NOT NULL)");
                    }
                    catch (SQLiteBusyException e) {
                        Thread.sleep(1L);
                        continue;
                    }
                    break;
                }
                while (SQLiteLoop.this._running) {
                    int i;
                    Query query = (Query)SQLiteLoop.this._queue.take();
                    if (SQLiteLoop.this._ongoing == null) {
                        query.run(db);
                        continue;
                    }
                    if (SQLiteLoop.this._walks.size() == 0) {
                        db.exec("BEGIN IMMEDIATE");
                    }
                    while (query != null) {
                        query.run(db);
                        toAck.add((Object)query);
                        query = (Query)SQLiteLoop.this._queue.poll();
                    }
                    if (SQLiteLoop.this._walks.size() != 0) continue;
                    while (true) {
                        try {
                            db.exec("COMMIT");
                        }
                        catch (SQLiteBusyException e) {
                            Thread.sleep(1L);
                            continue;
                        }
                        break;
                    }
                    int count = 0;
                    for (i = 0; i < toAck.size(); ++i) {
                        count += ((Query)toAck.get(i)).statements();
                    }
                    SQLiteLoop.this._ongoing.addAndGet(-count);
                    for (i = 0; i < toAck.size(); ++i) {
                        ((Query)toAck.get(i)).ack();
                    }
                    toAck.clear();
                }
            }
            catch (Exception e) {
                if (!(e instanceof InterruptedException)) {
                    Log.write((Throwable)e);
                }
            }
            finally {
                db.dispose();
            }
        }
    }

    static abstract class Query {
        Query() {
        }

        int statements() {
            return 1;
        }

        abstract void run(SQLiteConnection var1) throws SQLiteException;

        void ack() {
        }
    }
}

