/*
 * Decompiled with CFR 0.152.
 */
package org.objectfabric;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import org.objectfabric.BlockQueue;
import org.objectfabric.Buff;
import org.objectfabric.CloseCounter;
import org.objectfabric.List;
import org.objectfabric.Location;
import org.objectfabric.Peer;
import org.objectfabric.Platform;
import org.objectfabric.SQLite;
import org.objectfabric.SQLiteLoop;
import org.objectfabric.SQLiteView;
import org.objectfabric.Tick;
import org.objectfabric.URI;
import org.objectfabric.View;

final class SQLiteQueue
extends BlockQueue
implements Runnable {
    private final SQLite _location;

    SQLiteQueue(SQLite location) {
        this._location = location;
        this.onStarted();
    }

    void onClose(CloseCounter.Callback callback) {
        super.onClose(callback);
    }

    protected void enqueue() {
        Platform.get().execute((Runnable)this);
    }

    @Override
    public void run() {
        if (this.onRunStarting()) {
            BlockQueue.Block block;
            this.runMessages(false);
            final List list = new List();
            int room = this._location.writer().room();
            for (int i = 0; i < room && (block = this.nextBlock()) != null; ++i) {
                list.add((Object)block);
            }
            if (list.size() > 0) {
                this._location.writer().add(new SQLiteLoop.Query(){

                    @Override
                    int statements() {
                        return list.size();
                    }

                    @Override
                    void run(SQLiteConnection db) throws SQLiteException {
                        for (int i = 0; i < list.size(); ++i) {
                            BlockQueue.Block block = (BlockQueue.Block)list.get(i);
                            SQLiteQueue.this.write(db, block.URI, block.Tick, block.Buffs, block.Removals);
                            for (int b = 0; b < block.Buffs.length; ++b) {
                                block.Buffs[b].recycle();
                            }
                        }
                    }

                    @Override
                    void ack() {
                        for (int i = 0; i < list.size(); ++i) {
                            BlockQueue.Block b = (BlockQueue.Block)list.get(i);
                            SQLiteQueue.this.ack(b.URI, b.Tick, b.Removals);
                        }
                        SQLiteQueue.this.requestRun();
                    }
                });
            }
            this.onRunEnded(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void write(SQLiteConnection db, URI uri, long tick, Buff[] buffs, long[] removals) throws SQLiteException {
        SQLiteView view = (SQLiteView)uri.getOrCreate((Location)this._location);
        SQLiteStatement st = db.prepare("REPLACE INTO blocks VALUES (?, ?, ?, ?)");
        try {
            st.bind(1, view.sha1());
            st.bind(2, Tick.time((long)tick));
            st.bind(3, Peer.get((int)Tick.peer((long)tick)).uid());
            int capacity = 0;
            for (int i = 0; i < buffs.length; ++i) {
                capacity += buffs[i].remaining();
            }
            byte[] array = new byte[capacity];
            int offset = 0;
            for (int i = 0; i < buffs.length; ++i) {
                int length = buffs[i].remaining();
                buffs[i].getImmutably(array, offset, length);
                offset += length;
            }
            st.bind(4, array);
            st.step();
        }
        finally {
            st.dispose();
        }
        if (removals != null) {
            for (int i = 0; i < removals.length; ++i) {
                if (Tick.isNull((long)removals[i])) continue;
                this.delete(db, view, removals[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void delete(SQLiteConnection db, SQLiteView view, long tick) throws SQLiteException {
        SQLiteStatement st = db.prepare("DELETE FROM blocks WHERE sha1=? AND time=? AND peer=?");
        try {
            st.bind(1, view.sha1());
            st.bind(2, Tick.time((long)tick));
            st.bind(3, Peer.get((int)Tick.peer((long)tick)).uid());
            st.step();
        }
        finally {
            st.dispose();
        }
    }

    private final void ack(URI uri, long tick, long[] removals) {
        SQLiteView view = (SQLiteView)uri.getOrCreate((Location)this._location);
        uri.onAck((View)view, tick);
        view.add(tick, removals);
    }
}

