/*
 * Decompiled with CFR 0.152.
 */
package org.objectfabric;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import org.objectfabric.ArrayView;
import org.objectfabric.Buff;
import org.objectfabric.InFlight;
import org.objectfabric.JVMBuff;
import org.objectfabric.List;
import org.objectfabric.Location;
import org.objectfabric.Log;
import org.objectfabric.Peer;
import org.objectfabric.SQLite;
import org.objectfabric.SQLiteLoop;
import org.objectfabric.Tick;
import org.objectfabric.UID;
import org.objectfabric.URI;

final class SQLiteView
extends ArrayView {
    private final byte[] _sha1;

    SQLiteView(Location location, byte[] sha1) {
        super(location);
        this._sha1 = sha1;
    }

    final byte[] sha1() {
        return this._sha1;
    }

    private final SQLite db() {
        return (SQLite)this.location();
    }

    final void getKnown(URI uri) {
        long[] ticks = this.copy();
        if (ticks != null) {
            if (ticks.length != 0 || !this.location().isCache()) {
                uri.onKnown((Object)this, ticks);
            }
        } else {
            this.list(uri, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onKnown(URI uri, long[] ticks) {
        boolean load;
        SQLiteView sQLiteView = this;
        synchronized (sQLiteView) {
            load = this.isNull();
        }
        if (load) {
            this.list(uri, ticks);
        } else {
            this.getUnknown(uri, ticks);
        }
    }

    private final void list(final URI uri, final long[] compare) {
        this.db().readers().add(new SQLiteLoop.Query(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void run(SQLiteConnection db) throws SQLiteException {
                SQLiteStatement st = db.prepare("SELECT time, peer FROM blocks WHERE sha1=?");
                try {
                    long[] ticks = null;
                    st.bind(1, SQLiteView.this._sha1);
                    while (st.step()) {
                        long time = st.columnLong(0);
                        byte[] peer = st.columnBlob(1);
                        ticks = Tick.add((long[])ticks, (long)Tick.get((int)Peer.get((UID)new UID(peer)).index(), (long)time));
                    }
                    if (ticks == null) {
                        ticks = Tick.EMPTY;
                    }
                    SQLiteView.this.onLoad(uri, ticks, compare);
                }
                finally {
                    st.dispose();
                }
            }
        });
    }

    void getBlock(final URI uri, final long tick) {
        if (!this.contains(tick)) {
            return;
        }
        this.db().readers().add(new SQLiteLoop.Query(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void run(SQLiteConnection db) throws SQLiteException {
                if (InFlight.starting((URI)uri, (long)tick)) {
                    List list;
                    block9: {
                        SQLiteStatement st = db.prepare("SELECT block FROM blocks WHERE sha1=? AND time=? AND peer=?");
                        list = new List();
                        try {
                            st.bind(1, SQLiteView.this._sha1);
                            st.bind(2, Tick.time((long)tick));
                            st.bind(3, Peer.get((int)Tick.peer((long)tick)).uid());
                            if (!st.step()) break block9;
                            byte[] block = st.columnBlob(0);
                            JVMBuff buff = JVMBuff.getWithPosition((int)0);
                            int offset = 0;
                            while (true) {
                                int length = Math.min(buff.remaining(), block.length - offset);
                                buff.putImmutably(block, offset, length);
                                buff.limit(buff.position() + length);
                                list.add((Object)buff);
                                if ((offset += length) == block.length) {
                                    break;
                                }
                                buff = JVMBuff.getWithPosition((int)Buff.getLargestUnsplitable());
                            }
                        }
                        finally {
                            st.dispose();
                        }
                    }
                    if (list.size() > 0) {
                        Object[] buffs = new JVMBuff[list.size()];
                        list.copyToFixed(buffs);
                        Exception exception = uri.onBlock((Object)SQLiteView.this, tick, (Buff[])buffs, null, true, null, false, null);
                        if (exception != null) {
                            Log.write((String)("Corrupted block " + exception.toString()));
                        }
                        for (int i = 0; i < buffs.length; ++i) {
                            buffs[i].recycle();
                        }
                    }
                }
            }
        });
    }

    final void onBlock(URI uri, long tick, Buff[] buffs, long[] removals, boolean requested) {
        this.db().queue().enqueueBlock(uri, tick, buffs, removals, requested);
    }
}

