/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.threetenbp.ThreeTenModule;
import feign.Feign;
import feign.Logger;
import feign.RequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormEncoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.slf4j.Slf4jLogger;
import io.swagger.client.CustomInstantDeserializer;
import io.swagger.client.RFC3339DateFormat;
import io.swagger.client.StringUtil;
import io.swagger.client.auth.ApiKeyAuth;
import io.swagger.client.auth.HttpBasicAuth;
import io.swagger.client.auth.OAuth;
import java.text.DateFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.threeten.bp.Instant;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.ZonedDateTime;

public class ApiClient {
    protected ObjectMapper objectMapper = this.createObjectMapper();
    private String basePath = "http://localhost:8585/api";
    private Map<String, RequestInterceptor> apiAuthorizations = new LinkedHashMap<String, RequestInterceptor>();
    private Feign.Builder feignBuilder = Feign.builder().encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(this.objectMapper))).decoder((Decoder)new JacksonDecoder(this.objectMapper)).logger((Logger)new Slf4jLogger());

    public ApiClient() {
    }

    public ApiClient(String[] authNames) {
        this();
        String[] stringArray = authNames;
        int n = stringArray.length;
        int n2 = 0;
        if (n2 < n) {
            String authName = stringArray[n2];
            throw new RuntimeException("auth name \"" + authName + "\" not found in available auth names");
        }
    }

    public ApiClient(String authName) {
        this(new String[]{authName});
    }

    public ApiClient(String authName, String apiKey) {
        this(authName);
        this.setApiKey(apiKey);
    }

    public ApiClient(String authName, String username, String password) {
        this(authName);
        this.setCredentials(username, password);
    }

    public ApiClient(String authName, String clientId, String secret, String username, String password) {
        this(authName);
        this.getTokenEndPoint().setClientId(clientId).setClientSecret(secret).setUsername(username).setPassword(password);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public Map<String, RequestInterceptor> getApiAuthorizations() {
        return this.apiAuthorizations;
    }

    public void setApiAuthorizations(Map<String, RequestInterceptor> apiAuthorizations) {
        this.apiAuthorizations = apiAuthorizations;
    }

    public Feign.Builder getFeignBuilder() {
        return this.feignBuilder;
    }

    public ApiClient setFeignBuilder(Feign.Builder feignBuilder) {
        this.feignBuilder = feignBuilder;
        return this;
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        objectMapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.disable(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.setDateFormat((DateFormat)((Object)new RFC3339DateFormat()));
        ThreeTenModule module = new ThreeTenModule();
        module.addDeserializer(Instant.class, CustomInstantDeserializer.INSTANT);
        module.addDeserializer(OffsetDateTime.class, CustomInstantDeserializer.OFFSET_DATE_TIME);
        module.addDeserializer(ZonedDateTime.class, CustomInstantDeserializer.ZONED_DATE_TIME);
        objectMapper.registerModule((Module)module);
        return objectMapper;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public <T extends Api> T buildClient(Class<T> clientClass) {
        return (T)((Api)this.feignBuilder.target(clientClass, this.basePath));
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        if (StringUtil.containsIgnoreCase(accepts, "application/json")) {
            return "application/json";
        }
        return StringUtil.join(accepts, ",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0) {
            return "application/json";
        }
        if (StringUtil.containsIgnoreCase(contentTypes, "application/json")) {
            return "application/json";
        }
        return contentTypes[0];
    }

    public void setApiKey(String apiKey) {
        for (RequestInterceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (!(apiAuthorization instanceof ApiKeyAuth)) continue;
            ApiKeyAuth keyAuth = (ApiKeyAuth)apiAuthorization;
            keyAuth.setApiKey(apiKey);
            return;
        }
        throw new RuntimeException("No API key authentication configured!");
    }

    public void setCredentials(String username, String password) {
        for (RequestInterceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (apiAuthorization instanceof HttpBasicAuth) {
                HttpBasicAuth basicAuth = (HttpBasicAuth)apiAuthorization;
                basicAuth.setCredentials(username, password);
                return;
            }
            if (!(apiAuthorization instanceof OAuth)) continue;
            OAuth oauth = (OAuth)apiAuthorization;
            oauth.getTokenRequestBuilder().setUsername(username).setPassword(password);
            return;
        }
        throw new RuntimeException("No Basic authentication or OAuth configured!");
    }

    public OAuthClientRequest.TokenRequestBuilder getTokenEndPoint() {
        for (RequestInterceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (!(apiAuthorization instanceof OAuth)) continue;
            OAuth oauth = (OAuth)apiAuthorization;
            return oauth.getTokenRequestBuilder();
        }
        return null;
    }

    public OAuthClientRequest.AuthenticationRequestBuilder getAuthorizationEndPoint() {
        for (RequestInterceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (!(apiAuthorization instanceof OAuth)) continue;
            OAuth oauth = (OAuth)apiAuthorization;
            return oauth.getAuthenticationRequestBuilder();
        }
        return null;
    }

    public void setAccessToken(String accessToken, Long expiresIn) {
        for (RequestInterceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (!(apiAuthorization instanceof OAuth)) continue;
            OAuth oauth = (OAuth)apiAuthorization;
            oauth.setAccessToken(accessToken, expiresIn);
            return;
        }
    }

    public void configureAuthorizationFlow(String clientId, String clientSecret, String redirectURI) {
        for (RequestInterceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (!(apiAuthorization instanceof OAuth)) continue;
            OAuth oauth = (OAuth)apiAuthorization;
            oauth.getTokenRequestBuilder().setClientId(clientId).setClientSecret(clientSecret).setRedirectURI(redirectURI);
            oauth.getAuthenticationRequestBuilder().setClientId(clientId).setRedirectURI(redirectURI);
            return;
        }
    }

    public void registerAccessTokenListener(OAuth.AccessTokenListener accessTokenListener) {
        for (RequestInterceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (!(apiAuthorization instanceof OAuth)) continue;
            OAuth oauth = (OAuth)apiAuthorization;
            oauth.registerAccessTokenListener(accessTokenListener);
            return;
        }
    }

    public RequestInterceptor getAuthorization(String authName) {
        return this.apiAuthorizations.get(authName);
    }

    public void addAuthorization(String authName, RequestInterceptor authorization) {
        if (this.apiAuthorizations.containsKey(authName)) {
            throw new RuntimeException("auth name \"" + authName + "\" already in api authorizations");
        }
        this.apiAuthorizations.put(authName, authorization);
        this.feignBuilder.requestInterceptor(authorization);
    }

    public static interface Api {
    }
}

