/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import io.swagger.client.ApiClient;
import io.swagger.client.EncodingUtils;
import io.swagger.client.model.Bot;
import io.swagger.client.model.BotList;
import io.swagger.client.model.CreateBot;
import io.swagger.client.model.EntityHistory;
import java.util.HashMap;
import java.util.Map;

public interface BotsApi
extends ApiClient.Api {
    @RequestLine(value="POST /v1/bots")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Bot createBot(CreateBot var1);

    @RequestLine(value="PUT /v1/bots")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Bot createOrUpdateBot(CreateBot var1);

    @RequestLine(value="DELETE /v1/bots/{id}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public void deleteBot(@Param(value="id") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/bots/{id}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json"})
    public void deleteBot(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/bots/name/{fqn}?include={include}")
    @Headers(value={"Accept: application/json"})
    public Bot getBotByFQN(@Param(value="fqn") String var1, @Param(value="include") String var2);

    @RequestLine(value="GET /v1/bots/name/{fqn}?include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Bot getBotByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/bots/{id}?include={include}")
    @Headers(value={"Accept: application/json"})
    public Bot getBotByID(@Param(value="id") String var1, @Param(value="include") String var2);

    @RequestLine(value="GET /v1/bots/{id}?include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Bot getBotByID(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/bots/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllBotVersion(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/bots?limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public BotList listBots(@Param(value="limit") Integer var1, @Param(value="before") String var2, @Param(value="after") String var3, @Param(value="include") String var4);

    @RequestLine(value="GET /v1/bots?limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public BotList listBots(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/bots/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Bot listSpecificBotVersion(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="PATCH /v1/bots/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchBot(@Param(value="id") String var1, Object var2);

    public static class ListBotsQueryParams
    extends HashMap<String, Object> {
        public ListBotsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListBotsQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListBotsQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListBotsQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetBotByIDQueryParams
    extends HashMap<String, Object> {
        public GetBotByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetBotByFQNQueryParams
    extends HashMap<String, Object> {
        public GetBotByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteBotQueryParams
    extends HashMap<String, Object> {
        public DeleteBotQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

