/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import io.swagger.client.ApiClient;
import io.swagger.client.EncodingUtils;
import io.swagger.client.model.Chart;
import io.swagger.client.model.ChartList;
import io.swagger.client.model.CreateChart;
import io.swagger.client.model.EntityHistory;
import java.util.HashMap;
import java.util.Map;

public interface ChartsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/charts/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public void addFollowerToChart(@Param(value="id") String var1, String var2);

    @RequestLine(value="POST /v1/charts")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Chart createChart(CreateChart var1);

    @RequestLine(value="PUT /v1/charts")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Chart createOrUpdateChart(CreateChart var1);

    @RequestLine(value="DELETE /v1/charts/{id}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public void deleteChart(@Param(value="id") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/charts/{id}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json"})
    public void deleteChart(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/charts/{id}/followers/{userId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void deleteFollowerFromChart(@Param(value="id") String var1, @Param(value="userId") String var2);

    @RequestLine(value="GET /v1/charts/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Chart getChartByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/charts/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Chart getChartByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/charts/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Chart getChartByID(@Param(value="id") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/charts/{id}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Chart getChartByID(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/charts/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Chart getSpecificChartVersion(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/charts/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllChartVersions(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/charts?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public ChartList listCharts(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/charts?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public ChartList listCharts(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/charts/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchChart(@Param(value="id") String var1, Object var2);

    public static class ListChartsQueryParams
    extends HashMap<String, Object> {
        public ListChartsQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListChartsQueryParams service(String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListChartsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListChartsQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListChartsQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListChartsQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetChartByIDQueryParams
    extends HashMap<String, Object> {
        public GetChartByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetChartByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetChartByFQNQueryParams
    extends HashMap<String, Object> {
        public GetChartByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetChartByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteChartQueryParams
    extends HashMap<String, Object> {
        public DeleteChartQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

