/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import io.swagger.client.ApiClient;
import io.swagger.client.EncodingUtils;
import io.swagger.client.model.CreateDashboard;
import io.swagger.client.model.Dashboard;
import io.swagger.client.model.DashboardList;
import io.swagger.client.model.EntityHistory;
import java.util.HashMap;
import java.util.Map;

public interface DashboardsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/dashboards/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public void addFollowerToDashboard(@Param(value="id") String var1, String var2);

    @RequestLine(value="POST /v1/dashboards")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Dashboard createDashboard(CreateDashboard var1);

    @RequestLine(value="PUT /v1/dashboards")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Dashboard createOrUpdateDashboard(CreateDashboard var1);

    @RequestLine(value="DELETE /v1/dashboards/{id}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public void deleteDashboard(@Param(value="id") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/dashboards/{id}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json"})
    public void deleteDashboard(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/dashboards/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Dashboard getDashboardByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dashboards/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Dashboard getDashboardByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/dashboards/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Dashboard getDashboardByID(@Param(value="id") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/dashboards/{id}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Dashboard getDashboardByID(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/dashboards/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Dashboard getSpecificDashboardVersion(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/dashboards/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllDashboardVersion(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/dashboards?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DashboardList listDashboards(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/dashboards?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public DashboardList listDashboards(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/dashboards/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDashboard(@Param(value="id") String var1, Object var2);

    @RequestLine(value="DELETE /v1/dashboards/{id}/followers/{userId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void removeFollowerFromDashboard(@Param(value="id") String var1, @Param(value="userId") String var2);

    public static class ListDashboardsQueryParams
    extends HashMap<String, Object> {
        public ListDashboardsQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsQueryParams service(String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListDashboardsQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDashboardByIDQueryParams
    extends HashMap<String, Object> {
        public GetDashboardByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDashboardByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDashboardByFQNQueryParams
    extends HashMap<String, Object> {
        public GetDashboardByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDashboardByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDashboardQueryParams
    extends HashMap<String, Object> {
        public DeleteDashboardQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

