/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import io.swagger.client.ApiClient;
import io.swagger.client.EncodingUtils;
import io.swagger.client.model.CreateDatabaseSchema;
import io.swagger.client.model.DatabaseSchema;
import io.swagger.client.model.DatabaseSchemaList;
import io.swagger.client.model.EntityHistory;
import java.util.HashMap;
import java.util.Map;

public interface DatabaseSchemasApi
extends ApiClient.Api {
    @RequestLine(value="POST /v1/databaseSchemas")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DatabaseSchema createDBSchema(CreateDatabaseSchema var1);

    @RequestLine(value="PUT /v1/databaseSchemas")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public DatabaseSchema createOrUpdateDBSchema(CreateDatabaseSchema var1);

    @RequestLine(value="DELETE /v1/databaseSchemas/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public void deleteDBSchema(@Param(value="id") String var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/databaseSchemas/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json"})
    public void deleteDBSchema(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/databaseSchemas/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DatabaseSchema getDBSchemaByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/databaseSchemas/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public DatabaseSchema getDBSchemaByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/databaseSchemas/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DatabaseSchema getDBSchemaByID(@Param(value="id") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/databaseSchemas/{id}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public DatabaseSchema getDBSchemaByID(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/databaseSchemas/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public DatabaseSchema getSpecificDBSchemaVersion(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/databaseSchemas/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllDBSchemaVersion(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/databaseSchemas?fields={fields}&database={database}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DatabaseSchemaList listDBSchemas(@Param(value="fields") String var1, @Param(value="database") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/databaseSchemas?fields={fields}&database={database}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public DatabaseSchemaList listDBSchemas(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/databaseSchemas/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDBSchema(@Param(value="id") String var1, Object var2);

    public static class ListDBSchemasQueryParams
    extends HashMap<String, Object> {
        public ListDBSchemasQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListDBSchemasQueryParams database(String value) {
            this.put("database", EncodingUtils.encode(value));
            return this;
        }

        public ListDBSchemasQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListDBSchemasQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListDBSchemasQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListDBSchemasQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDBSchemaByIDQueryParams
    extends HashMap<String, Object> {
        public GetDBSchemaByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDBSchemaByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDBSchemaByFQNQueryParams
    extends HashMap<String, Object> {
        public GetDBSchemaByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDBSchemaByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDBSchemaQueryParams
    extends HashMap<String, Object> {
        public DeleteDBSchemaQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDBSchemaQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

