/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import io.swagger.client.ApiClient;
import io.swagger.client.EncodingUtils;
import io.swagger.client.model.CreateDatabase;
import io.swagger.client.model.Database;
import io.swagger.client.model.DatabaseList;
import io.swagger.client.model.EntityHistory;
import java.util.HashMap;
import java.util.Map;

public interface DatabasesApi
extends ApiClient.Api {
    @RequestLine(value="POST /v1/databases")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Database createDatabase(CreateDatabase var1);

    @RequestLine(value="PUT /v1/databases")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Database createOrUpdateDatabase(CreateDatabase var1);

    @RequestLine(value="DELETE /v1/databases/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public void deleteDatabase(@Param(value="id") String var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/databases/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json"})
    public void deleteDatabase(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/databases/{id}/location")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Database deleteLocation(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/databases/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Database getDatabaseByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/databases/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Database getDatabaseByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/databases/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Database getDatabaseByID(@Param(value="id") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/databases/{id}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Database getDatabaseByID(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/databases/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Database getSpecificDatabaseVersion(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/databases/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllDatabaseVersion(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/databases?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public DatabaseList listDatabases(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/databases?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public DatabaseList listDatabases(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/databases/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchDatabase(@Param(value="id") String var1, Object var2);

    public static class ListDatabasesQueryParams
    extends HashMap<String, Object> {
        public ListDatabasesQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListDatabasesQueryParams service(String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListDatabasesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListDatabasesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListDatabasesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListDatabasesQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDatabaseByIDQueryParams
    extends HashMap<String, Object> {
        public GetDatabaseByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDatabaseByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetDatabaseByFQNQueryParams
    extends HashMap<String, Object> {
        public GetDatabaseByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetDatabaseByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteDatabaseQueryParams
    extends HashMap<String, Object> {
        public DeleteDatabaseQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteDatabaseQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

