/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import io.swagger.client.ApiClient;
import io.swagger.client.EncodingUtils;
import io.swagger.client.model.CreateGlossary;
import io.swagger.client.model.EntityHistory;
import io.swagger.client.model.Glossary;
import io.swagger.client.model.GlossaryList;
import java.util.HashMap;
import java.util.Map;

public interface GlossariesApi
extends ApiClient.Api {
    @RequestLine(value="POST /v1/glossaries")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Glossary createGlossary(CreateGlossary var1);

    @RequestLine(value="PUT /v1/glossaries")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Glossary createOrUpdateGlossary(CreateGlossary var1);

    @RequestLine(value="DELETE /v1/glossaries/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public void deleteGlossary(@Param(value="id") String var1, @Param(value="recursive") Boolean var2, @Param(value="hardDelete") Boolean var3);

    @RequestLine(value="DELETE /v1/glossaries/{id}?recursive={recursive}&hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json"})
    public void deleteGlossary(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/glossaries/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Glossary getGlossaryByFQN(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/glossaries/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Glossary getGlossaryByFQN(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/glossaries/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Glossary getGlossaryByID(@Param(value="id") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/glossaries/{id}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Glossary getGlossaryByID(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/glossaries/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Glossary getSpecificGlossaryVersion(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/glossaries/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllGlossaryVersion(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/glossaries?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public GlossaryList listGlossaries(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="before") String var3, @Param(value="after") String var4, @Param(value="include") String var5);

    @RequestLine(value="GET /v1/glossaries?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public GlossaryList listGlossaries(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/glossaries/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchGlossary(@Param(value="id") String var1, Object var2);

    public static class ListGlossariesQueryParams
    extends HashMap<String, Object> {
        public ListGlossariesQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossariesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossariesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossariesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListGlossariesQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetGlossaryByIDQueryParams
    extends HashMap<String, Object> {
        public GetGlossaryByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetGlossaryByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetGlossaryByFQNQueryParams
    extends HashMap<String, Object> {
        public GetGlossaryByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetGlossaryByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteGlossaryQueryParams
    extends HashMap<String, Object> {
        public DeleteGlossaryQueryParams recursive(Boolean value) {
            this.put("recursive", EncodingUtils.encode(value));
            return this;
        }

        public DeleteGlossaryQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

