/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import io.swagger.client.ApiClient;
import io.swagger.client.EncodingUtils;
import io.swagger.client.model.CreateIngestionPipeline;
import io.swagger.client.model.EntityHistory;
import io.swagger.client.model.IngestionPipeline;
import io.swagger.client.model.TestServiceConnection;
import java.util.HashMap;
import java.util.Map;

public interface IngestionPipelinesApi
extends ApiClient.Api {
    @RequestLine(value="GET /v1/services/ingestionPipelines/status")
    @Headers(value={"Accept: application/json"})
    public void checkRestAirflowStatus();

    @RequestLine(value="POST /v1/services/ingestionPipelines")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public IngestionPipeline createIngestionPipeline(CreateIngestionPipeline var1);

    @RequestLine(value="PUT /v1/services/ingestionPipelines")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public IngestionPipeline createOrUpdateIngestionPipeline(CreateIngestionPipeline var1);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/{id}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public void deleteIngestionPipeline(@Param(value="id") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/services/ingestionPipelines/{id}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json"})
    public void deleteIngestionPipeline(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="POST /v1/services/ingestionPipelines/deploy/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public IngestionPipeline deployIngestion(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline getIngestionPipelineByID(@Param(value="id") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{id}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public IngestionPipeline getIngestionPipelineByID(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/logs/{id}/last")
    @Headers(value={"Accept: application/json"})
    public void getLastIngestionLogs(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/services/ingestionPipelines/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline getSpecificIngestionPipelineByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/services/ingestionPipelines/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public IngestionPipeline getSpecificIngestionPipelineByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline getSpecificIngestionPipelineVersion(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="POST /v1/services/ingestionPipelines/kill/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public IngestionPipeline killIngestionPipelineRuns(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/services/ingestionPipelines/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllIngestionPipelineVersion(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/services/ingestionPipelines?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public IngestionPipeline listIngestionPipelines(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/services/ingestionPipelines?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public IngestionPipeline listIngestionPipelines(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/services/ingestionPipelines/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchIngestionPipeline(@Param(value="id") String var1, Object var2);

    @RequestLine(value="POST /v1/services/ingestionPipelines/testConnection")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void testConnection(TestServiceConnection var1);

    @RequestLine(value="POST /v1/services/ingestionPipelines/toggleIngestion/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public IngestionPipeline toggleIngestionPipelineEnabled(@Param(value="id") String var1);

    @RequestLine(value="POST /v1/services/ingestionPipelines/trigger/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public IngestionPipeline triggerIngestionPipelineRun(@Param(value="id") String var1);

    public static class ListIngestionPipelinesQueryParams
    extends HashMap<String, Object> {
        public ListIngestionPipelinesQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams service(String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListIngestionPipelinesQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetSpecificIngestionPipelineByFQNQueryParams
    extends HashMap<String, Object> {
        public GetSpecificIngestionPipelineByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetSpecificIngestionPipelineByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetIngestionPipelineByIDQueryParams
    extends HashMap<String, Object> {
        public GetIngestionPipelineByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetIngestionPipelineByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteIngestionPipelineQueryParams
    extends HashMap<String, Object> {
        public DeleteIngestionPipelineQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

