/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import io.swagger.client.ApiClient;
import io.swagger.client.EncodingUtils;
import io.swagger.client.model.ChangeEvent;
import io.swagger.client.model.CreateLocation;
import io.swagger.client.model.EntityHistory;
import io.swagger.client.model.Location;
import io.swagger.client.model.LocationList;
import java.util.HashMap;
import java.util.Map;

public interface LocationsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/locations/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollower(@Param(value="id") String var1, String var2);

    @RequestLine(value="POST /v1/locations")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Location createLocation(CreateLocation var1);

    @RequestLine(value="PUT /v1/locations")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Location createOrUpdateLocation(CreateLocation var1);

    @RequestLine(value="DELETE /v1/locations/{id}/followers/{userId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent deleteFollower1(@Param(value="id") String var1, @Param(value="userId") String var2);

    @RequestLine(value="DELETE /v1/locations/{id}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public void deleteLocation2(@Param(value="id") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/locations/{id}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json"})
    public void deleteLocation2(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/locations/association/{id}")
    @Headers(value={"Accept: application/json"})
    public Location getEntityByLocation(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/locations/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Location getLocationByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/locations/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Location getLocationByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/locations/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Location getLocationByID(@Param(value="id") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/locations/{id}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Location getLocationByID(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/locations/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Location getSpecificLocationVersion(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/locations/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllLocationVersion(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/locations/prefixes/{fqn}?fields={fields}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public LocationList listLocationPrefixes(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5);

    @RequestLine(value="GET /v1/locations/prefixes/{fqn}?fields={fields}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public LocationList listLocationPrefixes(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/locations?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public LocationList listLocations(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/locations?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public LocationList listLocations(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/locations/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchLocation(@Param(value="id") String var1, Object var2);

    public static class ListLocationsQueryParams
    extends HashMap<String, Object> {
        public ListLocationsQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListLocationsQueryParams service(String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListLocationsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListLocationsQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListLocationsQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListLocationsQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListLocationPrefixesQueryParams
    extends HashMap<String, Object> {
        public ListLocationPrefixesQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListLocationPrefixesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListLocationPrefixesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListLocationPrefixesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetLocationByIDQueryParams
    extends HashMap<String, Object> {
        public GetLocationByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetLocationByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetLocationByFQNQueryParams
    extends HashMap<String, Object> {
        public GetLocationByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetLocationByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteLocation2QueryParams
    extends HashMap<String, Object> {
        public DeleteLocation2QueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

