/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import io.swagger.client.ApiClient;
import io.swagger.client.EncodingUtils;
import io.swagger.client.model.CreateType;
import io.swagger.client.model.CustomProperty;
import io.swagger.client.model.EntityHistory;
import io.swagger.client.model.Type;
import io.swagger.client.model.TypeList;
import java.util.HashMap;
import java.util.Map;

public interface MetadataApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/metadata/types/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public void addProperty(@Param(value="id") String var1, CustomProperty var2);

    @RequestLine(value="PUT /v1/metadata/types")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Type createOrUpdate(CreateType var1);

    @RequestLine(value="POST /v1/metadata/types")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Type createType(CreateType var1);

    @RequestLine(value="DELETE /v1/metadata/types/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public void deleteType(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/metadata/types/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Type getSpecificTypeVersion(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/metadata/types/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Type getTypeByFQN(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/metadata/types/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Type getTypeByFQN(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/metadata/types/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Type getTypeByID(@Param(value="id") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/metadata/types/{id}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Type getTypeByID(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/metadata/types/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllTypeVersion(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/metadata/types?category={category}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Accept: application/json"})
    public TypeList listTypes(@Param(value="category") String var1, @Param(value="limit") Integer var2, @Param(value="before") String var3, @Param(value="after") String var4);

    @RequestLine(value="GET /v1/metadata/types?category={category}&limit={limit}&before={before}&after={after}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public TypeList listTypes(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/metadata/types/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchType(@Param(value="id") String var1, Object var2);

    public static class ListTypesQueryParams
    extends HashMap<String, Object> {
        public ListTypesQueryParams category(String value) {
            this.put("category", EncodingUtils.encode(value));
            return this;
        }

        public ListTypesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTypesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListTypesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTypeByIDQueryParams
    extends HashMap<String, Object> {
        public GetTypeByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTypeByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTypeByFQNQueryParams
    extends HashMap<String, Object> {
        public GetTypeByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTypeByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }
}

