/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import io.swagger.client.ApiClient;
import io.swagger.client.EncodingUtils;
import io.swagger.client.model.ChangeEvent;
import io.swagger.client.model.CreatePipeline;
import io.swagger.client.model.EntityHistory;
import io.swagger.client.model.Pipeline;
import io.swagger.client.model.PipelineList;
import io.swagger.client.model.PipelineStatus;
import java.util.HashMap;
import java.util.Map;

public interface PipelinesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/pipelines/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollower2(@Param(value="id") String var1, String var2);

    @RequestLine(value="PUT /v1/pipelines/{id}/status")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Pipeline addStatusData(@Param(value="id") String var1, PipelineStatus var2);

    @RequestLine(value="PUT /v1/pipelines")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Pipeline createOrUpdatePipeline(CreatePipeline var1);

    @RequestLine(value="POST /v1/pipelines")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Pipeline createPipeline(CreatePipeline var1);

    @RequestLine(value="DELETE /v1/pipelines/{id}/followers/{userId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent deleteFollower3(@Param(value="id") String var1, @Param(value="userId") String var2);

    @RequestLine(value="DELETE /v1/pipelines/{id}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public void deletePipeline(@Param(value="id") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/pipelines/{id}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json"})
    public void deletePipeline(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/pipelines/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Pipeline getPipelineByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/pipelines/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Pipeline getPipelineByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/pipelines/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Pipeline getPipelineWithID(@Param(value="id") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/pipelines/{id}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Pipeline getPipelineWithID(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/pipelines/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Pipeline getSpecificPipelineVersion(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/pipelines/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllPipelineVersion(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/pipelines?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public PipelineList listPipelines(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/pipelines?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public PipelineList listPipelines(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/pipelines/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchPipeline(@Param(value="id") String var1, Object var2);

    public static class ListPipelinesQueryParams
    extends HashMap<String, Object> {
        public ListPipelinesQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelinesQueryParams service(String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelinesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelinesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelinesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListPipelinesQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetPipelineWithIDQueryParams
    extends HashMap<String, Object> {
        public GetPipelineWithIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetPipelineWithIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetPipelineByFQNQueryParams
    extends HashMap<String, Object> {
        public GetPipelineByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetPipelineByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeletePipelineQueryParams
    extends HashMap<String, Object> {
        public DeletePipelineQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

