/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import io.swagger.client.ApiClient;
import io.swagger.client.EncodingUtils;
import io.swagger.client.model.CreatePolicy;
import io.swagger.client.model.EntityHistory;
import io.swagger.client.model.Policy;
import io.swagger.client.model.PolicyList;
import java.util.HashMap;
import java.util.Map;

public interface PoliciesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/policies")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Policy createOrUpdatePolicy(CreatePolicy var1);

    @RequestLine(value="POST /v1/policies")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Policy createPolicy(CreatePolicy var1);

    @RequestLine(value="DELETE /v1/policies/{id}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public void deletePolicy(@Param(value="id") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/policies/{id}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json"})
    public void deletePolicy(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/policies/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Policy getPolicyByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/policies/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Policy getPolicyByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/policies/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Policy getPolicyByID(@Param(value="id") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/policies/{id}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Policy getPolicyByID(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/policies/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Policy getSpecificPolicyVersion(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/policies/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllPolicyVersion(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/policies?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public PolicyList listPolicies(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="before") String var3, @Param(value="after") String var4, @Param(value="include") String var5);

    @RequestLine(value="GET /v1/policies?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public PolicyList listPolicies(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/policies/resources")
    @Headers(value={"Accept: application/json"})
    public void listPolicyResources();

    @RequestLine(value="PATCH /v1/policies/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchPolicy(@Param(value="id") String var1, Object var2);

    public static class ListPoliciesQueryParams
    extends HashMap<String, Object> {
        public ListPoliciesQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListPoliciesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListPoliciesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListPoliciesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListPoliciesQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetPolicyByIDQueryParams
    extends HashMap<String, Object> {
        public GetPolicyByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetPolicyByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetPolicyByFQNQueryParams
    extends HashMap<String, Object> {
        public GetPolicyByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetPolicyByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeletePolicyQueryParams
    extends HashMap<String, Object> {
        public DeletePolicyQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

