/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import io.swagger.client.ApiClient;
import io.swagger.client.EncodingUtils;
import io.swagger.client.model.CreateRole;
import io.swagger.client.model.EntityHistory;
import io.swagger.client.model.Role;
import io.swagger.client.model.RoleList;
import java.util.HashMap;
import java.util.Map;

public interface RolesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/roles")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Role createOrUpdateRole(CreateRole var1);

    @RequestLine(value="POST /v1/roles")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Role createRole(CreateRole var1);

    @RequestLine(value="DELETE /v1/roles/{id}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public void deleteRole(@Param(value="id") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/roles/{id}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json"})
    public void deleteRole(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/roles/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Role getRoleByFQN(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/roles/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Role getRoleByFQN(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/roles/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Role getRoleByID(@Param(value="id") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/roles/{id}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Role getRoleByID(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/roles/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Role getSpecificRoleVersion(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/roles/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllRoleVersion(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/roles?default={_default}&fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public RoleList listRoles(@Param(value="_default") Boolean var1, @Param(value="fields") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/roles?default={_default}&fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public RoleList listRoles(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/roles/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchRole(@Param(value="id") String var1, Object var2);

    public static class ListRolesQueryParams
    extends HashMap<String, Object> {
        public ListRolesQueryParams _default(Boolean value) {
            this.put("default", EncodingUtils.encode(value));
            return this;
        }

        public ListRolesQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListRolesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListRolesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListRolesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListRolesQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetRoleByIDQueryParams
    extends HashMap<String, Object> {
        public GetRoleByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetRoleByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetRoleByFQNQueryParams
    extends HashMap<String, Object> {
        public GetRoleByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetRoleByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteRoleQueryParams
    extends HashMap<String, Object> {
        public DeleteRoleQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

