/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import io.swagger.client.ApiClient;
import io.swagger.client.EncodingUtils;
import io.swagger.client.model.ChangeEvent;
import io.swagger.client.model.CreateColumnTest;
import io.swagger.client.model.CreateCustomMetric;
import io.swagger.client.model.CreateTable;
import io.swagger.client.model.CreateTableTest;
import io.swagger.client.model.DataModel;
import io.swagger.client.model.EntityHistory;
import io.swagger.client.model.SQLQuery;
import io.swagger.client.model.Table;
import io.swagger.client.model.TableData;
import io.swagger.client.model.TableJoins;
import io.swagger.client.model.TableList;
import io.swagger.client.model.TableProfile;
import java.util.HashMap;
import java.util.Map;

public interface TablesApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/tables/{id}/columnTest")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table addColumnTest(@Param(value="id") String var1, CreateColumnTest var2);

    @RequestLine(value="PUT /v1/tables/{id}/customMetric")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table addCustomMetric(@Param(value="id") String var1, CreateCustomMetric var2);

    @RequestLine(value="PUT /v1/tables/{id}/dataModel")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table addDataModel(@Param(value="id") String var1, DataModel var2);

    @RequestLine(value="PUT /v1/tables/{id}/tableProfile")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table addDataProfiler(@Param(value="id") String var1, TableProfile var2);

    @RequestLine(value="PUT /v1/tables/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollowerToTable(@Param(value="id") String var1, String var2);

    @RequestLine(value="PUT /v1/tables/{id}/location")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table addLocationToTable(@Param(value="id") String var1, String var2);

    @RequestLine(value="PUT /v1/tables/{id}/sampleData")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table addSampleData(@Param(value="id") String var1, TableData var2);

    @RequestLine(value="PUT /v1/tables/{id}/joins")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table addTableJoinInfo(@Param(value="id") String var1, TableJoins var2);

    @RequestLine(value="PUT /v1/tables/{id}/tableQuery")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table addTableQuery(@Param(value="id") String var1, SQLQuery var2);

    @RequestLine(value="PUT /v1/tables/{id}/tableTest")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table addTableTest(@Param(value="id") String var1, CreateTableTest var2);

    @RequestLine(value="PUT /v1/tables")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table createOrUpdateTable(CreateTable var1);

    @RequestLine(value="POST /v1/tables")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table createTable(CreateTable var1);

    @RequestLine(value="DELETE /v1/tables/{id}/columnTest/{columnName}/{columnTestType}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table deleteColumnTest(@Param(value="id") String var1, @Param(value="columnName") String var2, @Param(value="columnTestType") String var3);

    @RequestLine(value="DELETE /v1/tables/{id}/customMetric/{columnName}/{customMetricName}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table deleteCustomMetric(@Param(value="id") String var1, @Param(value="columnName") String var2, @Param(value="customMetricName") String var3);

    @RequestLine(value="DELETE /v1/tables/{id}/followers/{userId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent deleteFollower(@Param(value="id") String var1, @Param(value="userId") String var2);

    @RequestLine(value="DELETE /v1/tables/{id}/location")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table deleteLocation1(@Param(value="id") String var1);

    @RequestLine(value="DELETE /v1/tables/{id}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public void deleteTable(@Param(value="id") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/tables/{id}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json"})
    public void deleteTable(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/tables/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public void deleteTable1(@Param(value="fqn") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/tables/name/{fqn}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json"})
    public void deleteTable1(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="DELETE /v1/tables/{id}/tableTest/{tableTestType}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Table deleteTableTest(@Param(value="id") String var1, @Param(value="tableTestType") String var2);

    @RequestLine(value="GET /v1/tables/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Table getSpecificDatabaseVersion1(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/tables/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Table getTableByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/tables/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Table getTableByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/tables/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Table getTableByID(@Param(value="id") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/tables/{id}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Table getTableByID(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/tables/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllTableVersion(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/tables?fields={fields}&database={database}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TableList listTables(@Param(value="fields") String var1, @Param(value="database") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/tables?fields={fields}&database={database}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public TableList listTables(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/tables/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTable(@Param(value="id") String var1, Object var2);

    public static class ListTablesQueryParams
    extends HashMap<String, Object> {
        public ListTablesQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListTablesQueryParams database(String value) {
            this.put("database", EncodingUtils.encode(value));
            return this;
        }

        public ListTablesQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTablesQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListTablesQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListTablesQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTableByIDQueryParams
    extends HashMap<String, Object> {
        public GetTableByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTableByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTableByFQNQueryParams
    extends HashMap<String, Object> {
        public GetTableByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTableByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTable1QueryParams
    extends HashMap<String, Object> {
        public DeleteTable1QueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTableQueryParams
    extends HashMap<String, Object> {
        public DeleteTableQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

