/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import io.swagger.client.ApiClient;
import io.swagger.client.EncodingUtils;
import io.swagger.client.model.CategoryList;
import io.swagger.client.model.CreateTag;
import io.swagger.client.model.CreateTagCategory;
import io.swagger.client.model.Tag;
import io.swagger.client.model.TagCategory;
import java.util.HashMap;
import java.util.Map;

public interface TagsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/tags/{category}/{primaryTag}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void createOrUpdatePrimaryTag(@Param(value="category") String var1, @Param(value="primaryTag") String var2, CreateTag var3);

    @RequestLine(value="PUT /v1/tags/{category}/{primaryTag}/{secondaryTag}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void createOrUpdateSecondaryTag(@Param(value="category") String var1, @Param(value="primaryTag") String var2, @Param(value="secondaryTag") String var3, CreateTag var4);

    @RequestLine(value="PUT /v1/tags/{category}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void createOrUpdateTagCategory(@Param(value="category") String var1, CreateTagCategory var2);

    @RequestLine(value="POST /v1/tags/{category}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Tag createPrimaryTag(@Param(value="category") String var1, CreateTag var2);

    @RequestLine(value="POST /v1/tags/{category}/{primaryTag}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Tag createSecondaryTag(@Param(value="category") String var1, @Param(value="primaryTag") String var2, CreateTag var3);

    @RequestLine(value="POST /v1/tags")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public TagCategory createTagCategory(CreateTagCategory var1);

    @RequestLine(value="DELETE /v1/tags/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void deleteTagCategory(@Param(value="id") String var1);

    @RequestLine(value="DELETE /v1/tags/{category}/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void deleteTags(@Param(value="category") String var1, @Param(value="id") String var2);

    @RequestLine(value="GET /v1/tags/{category}/{primaryTag}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public Tag getPrimaryTag(@Param(value="category") String var1, @Param(value="primaryTag") String var2, @Param(value="fields") String var3);

    @RequestLine(value="GET /v1/tags/{category}/{primaryTag}?fields={fields}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Tag getPrimaryTag(@Param(value="category") String var1, @Param(value="primaryTag") String var2, @QueryMap(encoded=true) Map<String, Object> var3);

    @RequestLine(value="GET /v1/tags/{category}/{primaryTag}/{secondaryTag}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public Tag getSecondaryTag(@Param(value="category") String var1, @Param(value="primaryTag") String var2, @Param(value="secondaryTag") String var3, @Param(value="fields") String var4);

    @RequestLine(value="GET /v1/tags/{category}/{primaryTag}/{secondaryTag}?fields={fields}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Tag getSecondaryTag(@Param(value="category") String var1, @Param(value="primaryTag") String var2, @Param(value="secondaryTag") String var3, @QueryMap(encoded=true) Map<String, Object> var4);

    @RequestLine(value="GET /v1/tags/{category}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public TagCategory getTagCategoryByName(@Param(value="category") String var1, @Param(value="fields") String var2);

    @RequestLine(value="GET /v1/tags/{category}?fields={fields}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public TagCategory getTagCategoryByName(@Param(value="category") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/tags?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public CategoryList listTagCategories(@Param(value="fields") String var1);

    @RequestLine(value="GET /v1/tags?fields={fields}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public CategoryList listTagCategories(@QueryMap(encoded=true) Map<String, Object> var1);

    public static class ListTagCategoriesQueryParams
    extends HashMap<String, Object> {
        public ListTagCategoriesQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTagCategoryByNameQueryParams
    extends HashMap<String, Object> {
        public GetTagCategoryByNameQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetSecondaryTagQueryParams
    extends HashMap<String, Object> {
        public GetSecondaryTagQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetPrimaryTagQueryParams
    extends HashMap<String, Object> {
        public GetPrimaryTagQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }
}

