/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import io.swagger.client.ApiClient;
import io.swagger.client.EncodingUtils;
import io.swagger.client.model.CreateTeam;
import io.swagger.client.model.EntityHistory;
import io.swagger.client.model.Team;
import io.swagger.client.model.TeamList;
import java.util.HashMap;
import java.util.Map;

public interface TeamsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/teams")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Team createOrUpdateTeam(CreateTeam var1);

    @RequestLine(value="POST /v1/teams")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Team createTeam(CreateTeam var1);

    @RequestLine(value="DELETE /v1/teams/{id}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public void deleteTeam(@Param(value="id") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/teams/{id}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json"})
    public void deleteTeam(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/teams/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Team getSpecificRoleVersion1(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/teams/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Team getTeamByFQN(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/teams/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Team getTeamByFQN(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/teams/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Team getTeamByID(@Param(value="id") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/teams/{id}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Team getTeamByID(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/teams/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllTeamVersion(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/teams?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TeamList listTeams(@Param(value="fields") String var1, @Param(value="limit") Integer var2, @Param(value="before") String var3, @Param(value="after") String var4, @Param(value="include") String var5);

    @RequestLine(value="GET /v1/teams?fields={fields}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public TeamList listTeams(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/teams/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTeam(@Param(value="id") String var1, Object var2);

    public static class ListTeamsQueryParams
    extends HashMap<String, Object> {
        public ListTeamsQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListTeamsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTeamsQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListTeamsQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListTeamsQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTeamByIDQueryParams
    extends HashMap<String, Object> {
        public GetTeamByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTeamByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTeamByFQNQueryParams
    extends HashMap<String, Object> {
        public GetTeamByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTeamByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTeamQueryParams
    extends HashMap<String, Object> {
        public DeleteTeamQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

