/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import io.swagger.client.ApiClient;
import io.swagger.client.EncodingUtils;
import io.swagger.client.model.ChangeEvent;
import io.swagger.client.model.CreateTopic;
import io.swagger.client.model.EntityHistory;
import io.swagger.client.model.Topic;
import io.swagger.client.model.TopicList;
import io.swagger.client.model.TopicSampleData;
import java.util.HashMap;
import java.util.Map;

public interface TopicsApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/topics/{id}/followers")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent addFollower3(@Param(value="id") String var1, String var2);

    @RequestLine(value="PUT /v1/topics/{id}/sampleData")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Topic addSampleData1(@Param(value="id") String var1, TopicSampleData var2);

    @RequestLine(value="PUT /v1/topics")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Topic createOrUpdateTopic(CreateTopic var1);

    @RequestLine(value="POST /v1/topics")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Topic createTopic(CreateTopic var1);

    @RequestLine(value="DELETE /v1/topics/{id}/followers/{userId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ChangeEvent deleteFollower4(@Param(value="id") String var1, @Param(value="userId") String var2);

    @RequestLine(value="DELETE /v1/topics/{id}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public void deleteTopic(@Param(value="id") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/topics/{id}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json"})
    public void deleteTopic(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/topics/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Topic get3(@Param(value="id") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/topics/{id}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Topic get3(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/topics/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public Topic getSpecificTopicVersion(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/topics/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public Topic getTopicByFQN(@Param(value="fqn") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/topics/name/{fqn}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public Topic getTopicByFQN(@Param(value="fqn") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/topics/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllTopicVersion(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/topics?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Accept: application/json"})
    public TopicList listTopics(@Param(value="fields") String var1, @Param(value="service") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="include") String var6);

    @RequestLine(value="GET /v1/topics?fields={fields}&service={service}&limit={limit}&before={before}&after={after}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public TopicList listTopics(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/topics/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchTopic(@Param(value="id") String var1, Object var2);

    public static class ListTopicsQueryParams
    extends HashMap<String, Object> {
        public ListTopicsQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListTopicsQueryParams service(String value) {
            this.put("service", EncodingUtils.encode(value));
            return this;
        }

        public ListTopicsQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListTopicsQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListTopicsQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListTopicsQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTopicByFQNQueryParams
    extends HashMap<String, Object> {
        public GetTopicByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetTopicByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class Get3QueryParams
    extends HashMap<String, Object> {
        public Get3QueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public Get3QueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteTopicQueryParams
    extends HashMap<String, Object> {
        public DeleteTopicQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

