/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.api;

import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import io.swagger.client.ApiClient;
import io.swagger.client.EncodingUtils;
import io.swagger.client.model.CreateUser;
import io.swagger.client.model.EntityHistory;
import io.swagger.client.model.GenerateTokenRequest;
import io.swagger.client.model.JWTAuthMechanism;
import io.swagger.client.model.User;
import io.swagger.client.model.UserList;
import java.util.HashMap;
import java.util.Map;

public interface UsersApi
extends ApiClient.Api {
    @RequestLine(value="PUT /v1/users")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public CreateUser createOrUpdateUser(CreateUser var1);

    @RequestLine(value="POST /v1/users")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public User createUser(CreateUser var1);

    @RequestLine(value="DELETE /v1/users/{id}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public void deleteUser(@Param(value="id") String var1, @Param(value="hardDelete") Boolean var2);

    @RequestLine(value="DELETE /v1/users/{id}?hardDelete={hardDelete}")
    @Headers(value={"Content-Type: application/json"})
    public void deleteUser(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="PUT /v1/users/generateToken/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public String generateJWTTokenForBotUser(@Param(value="id") String var1, GenerateTokenRequest var2);

    @RequestLine(value="GET /v1/users/loggedInUser?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public User getCurrentLoggedInUser(@Param(value="fields") String var1);

    @RequestLine(value="GET /v1/users/loggedInUser?fields={fields}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public User getCurrentLoggedInUser(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="GET /v1/users/token/{id}")
    @Headers(value={"Accept: application/json"})
    public JWTAuthMechanism getJWTTokenForBotUser(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/users/{id}/versions/{version}")
    @Headers(value={"Accept: application/json"})
    public User getSpecificUserVersion(@Param(value="id") String var1, @Param(value="version") String var2);

    @RequestLine(value="GET /v1/users/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public User getUserByFQN(@Param(value="name") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/users/name/{name}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public User getUserByFQN(@Param(value="name") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/users/{id}?fields={fields}&include={include}")
    @Headers(value={"Accept: application/json"})
    public User getUserByID(@Param(value="id") String var1, @Param(value="fields") String var2, @Param(value="include") String var3);

    @RequestLine(value="GET /v1/users/{id}?fields={fields}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public User getUserByID(@Param(value="id") String var1, @QueryMap(encoded=true) Map<String, Object> var2);

    @RequestLine(value="GET /v1/users/{id}/versions")
    @Headers(value={"Accept: application/json"})
    public EntityHistory listAllUserVersion(@Param(value="id") String var1);

    @RequestLine(value="GET /v1/users?fields={fields}&team={team}&limit={limit}&before={before}&after={after}&isAdmin={isAdmin}&isBot={isBot}&include={include}")
    @Headers(value={"Accept: application/json"})
    public UserList listUsers(@Param(value="fields") String var1, @Param(value="team") String var2, @Param(value="limit") Integer var3, @Param(value="before") String var4, @Param(value="after") String var5, @Param(value="isAdmin") Boolean var6, @Param(value="isBot") Boolean var7, @Param(value="include") String var8);

    @RequestLine(value="GET /v1/users?fields={fields}&team={team}&limit={limit}&before={before}&after={after}&isAdmin={isAdmin}&isBot={isBot}&include={include}")
    @Headers(value={"Content-Type: */*", "Accept: application/json"})
    public UserList listUsers(@QueryMap(encoded=true) Map<String, Object> var1);

    @RequestLine(value="PATCH /v1/users/{id}")
    @Headers(value={"Content-Type: application/json-patch+json", "Accept: application/json"})
    public void patchUser(@Param(value="id") String var1, Object var2);

    @RequestLine(value="PUT /v1/users/revokeToken/{id}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public JWTAuthMechanism revokeJWTTokenForBotUser(@Param(value="id") String var1);

    public static class ListUsersQueryParams
    extends HashMap<String, Object> {
        public ListUsersQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListUsersQueryParams team(String value) {
            this.put("team", EncodingUtils.encode(value));
            return this;
        }

        public ListUsersQueryParams limit(Integer value) {
            this.put("limit", EncodingUtils.encode(value));
            return this;
        }

        public ListUsersQueryParams before(String value) {
            this.put("before", EncodingUtils.encode(value));
            return this;
        }

        public ListUsersQueryParams after(String value) {
            this.put("after", EncodingUtils.encode(value));
            return this;
        }

        public ListUsersQueryParams isAdmin(Boolean value) {
            this.put("isAdmin", EncodingUtils.encode(value));
            return this;
        }

        public ListUsersQueryParams isBot(Boolean value) {
            this.put("isBot", EncodingUtils.encode(value));
            return this;
        }

        public ListUsersQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetUserByIDQueryParams
    extends HashMap<String, Object> {
        public GetUserByIDQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetUserByIDQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetUserByFQNQueryParams
    extends HashMap<String, Object> {
        public GetUserByFQNQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public GetUserByFQNQueryParams include(String value) {
            this.put("include", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetCurrentLoggedInUserQueryParams
    extends HashMap<String, Object> {
        public GetCurrentLoggedInUserQueryParams fields(String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class DeleteUserQueryParams
    extends HashMap<String, Object> {
        public DeleteUserQueryParams hardDelete(Boolean value) {
            this.put("hardDelete", EncodingUtils.encode(value));
            return this;
        }
    }
}

